/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageText;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageItemStack
extends PageText {
    public Ingredient ingredient;
    private final IngredientCycler ingredientCycler = new IngredientCycler();

    public PageItemStack(ITextProperties draw, Ingredient ingredient) {
        super(draw, 60);
        this.ingredient = ingredient;
    }

    public PageItemStack(ITextProperties draw, ItemStack ingredient) {
        this(draw, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ingredient}));
    }

    public PageItemStack(ITextProperties draw, Item item) {
        this(draw, new ItemStack((IItemProvider)item));
    }

    public PageItemStack(ITextProperties draw, Block block) {
        this(draw, new ItemStack((IItemProvider)block));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        this.ingredientCycler.tick(guiBase.getMinecraft());
        this.ingredientCycler.getCycledIngredientStack(this.ingredient, 0).ifPresent(s -> GuiHelper.drawScaledItemStack(stack, s, guiLeft + 101, guiTop + 20, 3.0f));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageItemStack)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageItemStack that = (PageItemStack)o;
        return this.ingredient != null ? this.ingredient.equals(that.ingredient) : that.ingredient == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ingredient != null ? this.ingredient.hashCode() : 0);
        return result;
    }
}

