/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.page.PageIRecipe;
import de.maxanier.guideapi.util.LogHelper;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageJsonRecipe
extends PageIRecipe {
    @Nonnull
    private final ResourceLocation recipeId;
    @Nonnull
    private final Function<IRecipe<?>, IRecipeRenderer> recipeRendererSupplier;

    public PageJsonRecipe(ResourceLocation recipeId) {
        this(recipeId, PageIRecipe::getRenderer);
    }

    public PageJsonRecipe(ResourceLocation recipeId, Function<IRecipe<?>, IRecipeRenderer> rendererSupplier) {
        super(null, null);
        this.recipeId = recipeId;
        this.recipeRendererSupplier = rendererSupplier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack, EntryScreen guiEntry) {
        super.onInit(book, category, entry, player, bookStack, guiEntry);
        if (this.recipe == null) {
            IRecipe iRecipe = this.recipe = Minecraft.func_71410_x().func_147114_u() == null ? null : (IRecipe)Minecraft.func_71410_x().func_147114_u().func_199526_e().func_215367_a(this.recipeId).orElse(null);
            if (this.recipe == null) {
                LogHelper.error("Cannot find recipe " + this.recipeId.toString());
            } else if (this.iRecipeRenderer == null) {
                this.iRecipeRenderer = this.recipeRendererSupplier.apply(this.recipe);
                if (this.iRecipeRenderer == null) {
                    LogHelper.error("Did not get renderer for recipe type " + this.recipe.getClass().toString() + " for recipe " + this.recipeId.toString());
                }
            }
        }
        this.isValid = this.recipe != null && this.iRecipeRenderer != null;
    }
}

