/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageTextImage
extends Page {
    public PageText pageText;
    public ResourceLocation image;
    public boolean drawAtTop;

    public PageTextImage(ITextProperties draw, ResourceLocation image, boolean drawAtTop) {
        this.pageText = new PageText(draw, drawAtTop ? 0 : 100);
        this.image = image;
        this.drawAtTop = drawAtTop;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        GuiHelper.drawSizedIconWithoutColor(stack, guiLeft + 60, guiTop + (this.drawAtTop ? 60 : 12), guiBase.xSize, guiBase.ySize, 0.0f);
        this.pageText.draw(stack, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageTextImage)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageTextImage that = (PageTextImage)o;
        if (this.drawAtTop != that.drawAtTop) {
            return false;
        }
        if (this.pageText != null ? !this.pageText.equals(that.pageText) : that.pageText != null) {
            return false;
        }
        return this.image != null ? this.image.equals((Object)that.image) : that.image == null;
    }

    public int hashCode() {
        int result = this.pageText != null ? this.pageText.hashCode() : 0;
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.drawAtTop ? 1 : 0);
        return result;
    }
}

