/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.proxy;

import de.maxanier.guideapi.api.BookEvent;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.NBTBookTags;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import de.maxanier.guideapi.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ClientProxy
extends CommonProxy {
    @Override
    public void playSound(SoundEvent sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)sound, (float)1.0f));
    }

    @Override
    public void openEntry(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, PlayerEntity player, ItemStack stack) {
        BookEvent.Open event = new BookEvent.Open(book, stack, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            player.func_146105_b(event.getCanceledText(), true);
            return;
        }
        Minecraft.func_71410_x().func_147108_a((Screen)new EntryScreen(book, categoryAbstract, entryAbstract, player, stack));
    }

    @Override
    public void initColors() {
        for (ItemStack bookStack : GuideAPI.getBookToStack().values()) {
            Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
                IGuideItem guideItem = (IGuideItem)stack.func_77973_b();
                if (guideItem.getBook(stack) != null && tintIndex == 0) {
                    return guideItem.getBook(stack).getColor().getRGB();
                }
                return -1;
            }, new IItemProvider[]{bookStack.func_77973_b()});
        }
    }

    @Override
    public void openGuidebook(PlayerEntity player, World world, Book book, ItemStack bookStack) {
        if (!bookStack.func_190926_b() && bookStack.func_77973_b() instanceof IGuideItem) {
            book.initializeContent();
            try {
                if (bookStack.func_77942_o()) {
                    CompoundNBT tagCompound = bookStack.func_77978_p();
                    if (tagCompound.func_74764_b(NBTBookTags.ENTRY_TAG) && tagCompound.func_74764_b(NBTBookTags.CATEGORY_TAG)) {
                        CategoryAbstract category = book.getCategoryList().get(tagCompound.func_74762_e(NBTBookTags.CATEGORY_TAG));
                        EntryAbstract entry = category.entries.get(new ResourceLocation(tagCompound.func_74779_i(NBTBookTags.ENTRY_TAG)));
                        int pageNumber = tagCompound.func_74762_e(NBTBookTags.PAGE_TAG);
                        EntryScreen guiEntry = new EntryScreen(book, category, entry, player, bookStack);
                        guiEntry.pageNumber = pageNumber;
                        Minecraft.func_71410_x().func_147108_a((Screen)guiEntry);
                        return;
                    }
                    if (tagCompound.func_74764_b(NBTBookTags.CATEGORY_TAG)) {
                        CategoryAbstract category = book.getCategoryList().get(tagCompound.func_74762_e(NBTBookTags.CATEGORY_TAG));
                        int entryPage = tagCompound.func_74762_e(NBTBookTags.ENTRY_PAGE_TAG);
                        CategoryScreen guiCategory = new CategoryScreen(book, category, player, bookStack, null);
                        guiCategory.entryPage = entryPage;
                        Minecraft.func_71410_x().func_147108_a((Screen)guiCategory);
                        return;
                    }
                    int categoryNumber = tagCompound.func_74762_e(NBTBookTags.CATEGORY_PAGE_TAG);
                    HomeScreen guiHome = new HomeScreen(book, player, bookStack);
                    guiHome.categoryPage = categoryNumber;
                    Minecraft.func_71410_x().func_147108_a((Screen)guiHome);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Minecraft.func_71410_x().func_147108_a((Screen)new HomeScreen(book, player, bookStack));
        }
    }
}

