/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.GuideConfig;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.IGuideLinked;
import de.maxanier.guideapi.api.IInfoRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="guideapi-vp")
public class EventHandler {
    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            CompoundNBT tag = EventHandler.getModTag(player, "guideapi-vp");
            if (((Boolean)GuideConfig.COMMON.canSpawnWithBook.get()).booleanValue()) {
                for (Book book : GuideAPI.getBooks().values()) {
                    ForgeConfigSpec.BooleanValue bookSpawnConfig = GuideConfig.COMMON.SPAWN_BOOKS.get(book);
                    if (bookSpawnConfig != null && !((Boolean)bookSpawnConfig.get()).booleanValue() || tag.func_74767_n("hasInitial" + book.getRegistryName().toString())) continue;
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)GuideAPI.getStackFromBook(book));
                    tag.func_74757_a("hasInitial" + book.getRegistryName().toString(), true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Pre event) {
        Multimap<Block, IInfoRenderer> bookRenderers;
        IGuideLinked linked;
        ResourceLocation entryKey;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        RayTraceResult rayTrace = Minecraft.func_71410_x().field_71476_x;
        if (rayTrace == null || rayTrace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ItemStack held = ItemStack.field_190927_a;
        Book book = null;
        for (Hand hand : Hand.values()) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (!(heldStack.func_77973_b() instanceof IGuideItem)) continue;
            held = heldStack;
            book = ((IGuideItem)heldStack.func_77973_b()).getBook(heldStack);
            break;
        }
        MatrixStack stack = event.getMatrixStack();
        if (book == null) {
            return;
        }
        BlockPos rayTracePos = ((BlockRayTraceResult)rayTrace).func_216350_a();
        BlockState state = world.func_180495_p(rayTracePos);
        ITextComponent linkedEntry = null;
        if (state.func_177230_c() instanceof IGuideLinked && (entryKey = (linked = (IGuideLinked)state.func_177230_c()).getLinkedEntry((World)world, rayTracePos, (PlayerEntity)player, held)) != null) {
            for (CategoryAbstract category : book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                linkedEntry = category.getEntry(entryKey).getName();
                break;
            }
        }
        if (linkedEntry != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int drawX = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + 10;
            int drawY = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 - 8;
            Minecraft.func_71410_x().func_175599_af().func_175042_a(held, drawX, drawY);
            fontRenderer.func_243246_a(stack, (ITextComponent)(linkedEntry instanceof IFormattableTextComponent ? ((IFormattableTextComponent)linkedEntry).func_240699_a_(TextFormatting.WHITE) : linkedEntry), (float)(drawX += 20), (float)(drawY -= 2), 0);
            fontRenderer.func_243246_a(stack, (ITextComponent)new TranslationTextComponent("guideapi.text.linked.open").func_240701_a_(new TextFormatting[]{TextFormatting.WHITE, TextFormatting.ITALIC}), (float)drawX, (float)(drawY + 12), 0);
        }
        if (state.func_177230_c() instanceof IInfoRenderer.Block) {
            IInfoRenderer infoRenderer = ((IInfoRenderer.Block)state.func_177230_c()).getInfoRenderer(book, (World)world, rayTracePos, state, rayTrace, (PlayerEntity)player);
            if (book == ((IInfoRenderer.Block)state.func_177230_c()).getBook() && infoRenderer != null) {
                infoRenderer.drawInformation(stack, book, (World)world, rayTracePos, state, rayTrace, (PlayerEntity)player);
            }
        }
        if ((bookRenderers = GuideAPI.getInfoRenderers().get(book)) == null) {
            return;
        }
        Collection renderers = bookRenderers.get((Object)state.func_177230_c());
        for (IInfoRenderer renderer : renderers) {
            renderer.drawInformation(stack, book, (World)world, rayTracePos, state, rayTrace, (PlayerEntity)player);
        }
    }

    public static CompoundNBT getModTag(PlayerEntity player, String modName) {
        CompoundNBT modTag;
        CompoundNBT persistTag;
        CompoundNBT tag = player.getPersistentData();
        if (tag.func_74764_b("PlayerPersisted")) {
            persistTag = tag.func_74775_l("PlayerPersisted");
        } else {
            persistTag = new CompoundNBT();
            tag.func_218657_a("PlayerPersisted", (INBT)persistTag);
        }
        if (persistTag.func_74764_b(modName)) {
            modTag = persistTag.func_74775_l(modName);
        } else {
            modTag = new CompoundNBT();
            persistTag.func_218657_a(modName, (INBT)modTag);
        }
        return modTag;
    }
}

