/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.impl.Book;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ReloadCommand {
    private static final DynamicCommandExceptionType BOOK_NOT_FOUND = new DynamicCommandExceptionType(id -> new StringTextComponent("Book with registry id " + id + " not found"));
    private static final SimpleCommandExceptionType NOT_CLIENT = new SimpleCommandExceptionType((Message)new LiteralMessage("This command can only be used in singleplayer"));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"reload").then(Commands.func_197056_a((String)"bookid", (ArgumentType)ResourceLocationArgument.func_197197_a()).executes(context -> {
            if (FMLEnvironment.dist != Dist.CLIENT) {
                throw NOT_CLIENT.create();
            }
            ResourceLocation id = ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"bookid");
            Book b = GuideAPI.getBooks().get(id);
            if (b == null) {
                throw BOOK_NOT_FOUND.create((Object)id.toString());
            }
            b.forceInitializeContent();
            return 0;
        }));
    }
}

