/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.environmental.common.entity.DuckEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuckModel<T extends DuckEntity>
extends AgeableModel<T> {
    public ModelRenderer head;
    public ModelRenderer body;
    public ModelRenderer rightLeg;
    public ModelRenderer leftLeg;
    public ModelRenderer rightWing;
    public ModelRenderer leftWing;

    public DuckModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.leftLeg = new ModelRenderer((Model)this, 0, 0);
        this.leftLeg.func_78793_a(1.5f, 20.0f, 1.0f);
        this.leftLeg.func_78784_a(48, 0).func_228302_a_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 20.0f, 0.0f);
        this.body.func_78784_a(14, 0).func_228302_a_(-3.0f, -4.0f, 0.0f, 6.0f, 8.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.body, 1.5707964f, 0.0f, 0.0f);
        this.leftWing = new ModelRenderer((Model)this, 0, 0);
        this.leftWing.func_78793_a(3.5f, 15.0f, -1.0f);
        this.leftWing.func_78784_a(30, 13).func_228302_a_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, 0.0f, 0.0f, 0.0f);
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(0.0f, 16.0f, -3.0f);
        this.head.func_228302_a_(-2.0f, -6.0f, -2.0f, 4.0f, 8.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 11).func_228302_a_(-1.5f, -4.0f, -5.0f, 3.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 0, 0);
        this.rightLeg.func_78793_a(-1.5f, 20.0f, 1.0f);
        this.rightLeg.func_78784_a(36, 0).func_228302_a_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.rightWing = new ModelRenderer((Model)this, 0, 0);
        this.rightWing.func_78793_a(-3.5f, 15.0f, -1.0f);
        this.rightWing.func_78784_a(14, 13).func_228302_a_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, 0.0f, 0.0f, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float f;
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.rightWing.field_78808_h = f = ((DuckEntity)entityIn).getWingRotation(partialTick);
        this.leftWing.field_78808_h = -f;
        if (((DuckEntity)entityIn).isEating()) {
            this.head.field_78795_f = ((DuckEntity)entityIn).getHeadLean(partialTick) * 2.5f;
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((DuckEntity)entityIn).field_70173_aa;
        float f1 = ((DuckEntity)entityIn).getHeadLean(f);
        float f2 = 1.0f - f1;
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180) * f2;
        this.head.field_78795_f += f1 * 1.4f + MathHelper.func_76134_b((float)ageInTicks) * 0.15f * f1;
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180) * f2;
        this.head.field_78797_d = 16.0f + f1;
        this.head.field_78798_e = -3.0f - f1;
        if (!entityIn.func_70090_H()) {
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightLeg.field_78797_d = 20.0f;
            this.leftLeg.field_78797_d = 20.0f;
        } else {
            float f3 = !entityIn.func_70631_g_() ? 0.2f : 0.4f;
            this.rightLeg.field_78795_f = 0.5f + MathHelper.func_76134_b((float)(ageInTicks * f3)) * 0.8f * (limbSwingAmount + 0.2f);
            this.leftLeg.field_78795_f = 0.5f + MathHelper.func_76134_b((float)(ageInTicks * f3 + (float)Math.PI)) * 0.8f * (limbSwingAmount + 0.2f);
            this.rightLeg.field_78797_d = 18.0f;
            this.leftLeg.field_78797_d = 18.0f;
        }
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

