/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.environmental.common.entity.FennecFoxEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FennecFoxModel
extends AgeableModel<FennecFoxEntity> {
    public final ModelRenderer head;
    private final ModelRenderer body;
    private final ModelRenderer legBackRight;
    private final ModelRenderer legBackLeft;
    private final ModelRenderer legFrontRight;
    private final ModelRenderer legFrontLeft;
    private final ModelRenderer tail;
    private float legMotion;

    public FennecFoxModel() {
        super(true, 9.35f, 1.0f);
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(-1.0f, 16.0f, -3.0f);
        this.head.func_78784_a(0, 0).func_228303_a_(-2.5f, -1.0f, -5.0f, 7.0f, 5.0f, 5.0f, 0.0f, false);
        this.head.func_78784_a(0, 10).func_228303_a_(-0.5f, 2.0f, -8.0f, 3.0f, 2.0f, 3.0f, 0.0f, false);
        ModelRenderer rightEar = new ModelRenderer((Model)this);
        rightEar.func_78793_a(1.0f, 1.0f, -1.0f);
        this.head.func_78792_a(rightEar);
        this.setRotationAngle(rightEar, 0.0f, -0.4363f, -0.4363f);
        rightEar.func_78784_a(24, 0).func_228303_a_(-3.0f, -8.0f, -1.0f, 3.0f, 6.0f, 1.0f, 0.0f, false);
        ModelRenderer leftEar = new ModelRenderer((Model)this);
        leftEar.func_78793_a(1.0f, 1.0f, -1.0f);
        this.head.func_78792_a(leftEar);
        this.setRotationAngle(leftEar, 0.0f, 0.4363f, 0.4363f);
        leftEar.func_78784_a(32, 0).func_228303_a_(0.0f, -8.0f, -1.0f, 3.0f, 6.0f, 1.0f, 0.0f, false);
        this.legFrontRight = new ModelRenderer((Model)this);
        this.legFrontRight.func_78793_a(0.5f, 19.5f, -2.0f);
        this.legFrontRight.func_78784_a(12, 20).func_228303_a_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.legFrontLeft = new ModelRenderer((Model)this);
        this.legFrontLeft.func_78793_a(3.5f, 19.5f, -2.0f);
        this.legFrontLeft.func_78784_a(20, 20).func_228303_a_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.legBackRight = new ModelRenderer((Model)this);
        this.legBackRight.func_78793_a(0.5f, 19.5f, 2.0f);
        this.legBackRight.func_78784_a(28, 20).func_228303_a_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.legBackLeft = new ModelRenderer((Model)this);
        this.legBackLeft.func_78793_a(3.5f, 19.5f, 2.0f);
        this.legBackLeft.func_78784_a(36, 20).func_228303_a_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 18.0f, -5.0f);
        this.setRotationAngle(this.body, 1.5708f, 0.0f, 0.0f);
        this.body.func_78784_a(12, 10).func_228303_a_(-2.5f, 2.0f, -3.0f, 5.0f, 6.0f, 4.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(2.0f, 8.0f, -1.0f);
        this.body.func_78792_a(this.tail);
        this.setRotationAngle(this.tail, -0.0524f, 0.0f, 0.0f);
        this.tail.func_78784_a(0, 15).func_228303_a_(-3.5f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f, 0.0f, false);
    }

    public void prepareMobModel(FennecFoxEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.body.field_78795_f = 1.5707964f;
        this.tail.field_78795_f = -0.05235988f;
        this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.head.func_78793_a(-1.0f, 16.0f, -3.0f);
        this.head.field_78796_g = 0.0f;
        this.head.field_78808_h = entityIn.func_213475_v(partialTick);
        this.legBackRight.field_78806_j = true;
        this.legBackLeft.field_78806_j = true;
        this.legFrontRight.field_78806_j = true;
        this.legFrontLeft.field_78806_j = true;
        this.body.func_78793_a(0.0f, 18.0f, -5.0f);
        this.body.field_78808_h = 0.0f;
        this.legBackRight.func_78793_a(0.5f, 19.5f, 2.0f);
        this.legBackLeft.func_78793_a(3.5f, 19.5f, 2.0f);
        if (entityIn.func_213453_ef()) {
            this.body.field_78795_f = 1.6755161f;
            float f = entityIn.func_213503_w(partialTick);
            this.body.func_78793_a(0.0f, 16.0f + entityIn.func_213503_w(partialTick), -5.0f);
            this.head.func_78793_a(-1.0f, 15.0f + f, -3.0f);
            this.head.field_78796_g = 0.0f;
        } else if (entityIn.func_70608_bn()) {
            this.body.field_78808_h = -1.5707964f;
            this.body.func_78793_a(-3.0f, 21.0f, -3.0f);
            this.tail.field_78795_f = -1.39626f;
            this.tail.func_78793_a(2.0f, 6.0f, -1.0f);
            if (this.field_217114_e) {
                this.body.func_78793_a(-3.0f, 21.0f, -1.0f);
            }
            this.head.func_78793_a(-1.0f, 19.49f, -4.0f);
            this.head.field_78795_f = 0.0f;
            this.head.field_78796_g = -2.0943952f;
            this.head.field_78808_h = 0.0f;
            this.legBackRight.field_78806_j = false;
            this.legBackLeft.field_78806_j = false;
            this.legFrontRight.field_78806_j = false;
            this.legFrontLeft.field_78806_j = false;
        } else if (entityIn.func_213455_dW()) {
            this.body.field_78795_f = 0.523599f;
            this.body.func_78793_a(0.0f, 15.0f, -2.0f);
            this.tail.field_78795_f = 0.872665f;
            this.tail.func_78793_a(2.0f, 8.0f, -1.0f);
            this.head.func_78793_a(-1.0f, 14.0f, -1.0f);
            this.head.field_78795_f = 0.0f;
            this.head.field_78796_g = 0.0f;
            if (this.field_217114_e) {
                this.head.func_78793_a(-1.0f, 14.5f, -1.5f);
            }
            this.legBackRight.field_78795_f = -1.5708f;
            this.legBackRight.func_78793_a(0.5f, 23.0f, 2.0f);
            this.legBackLeft.field_78795_f = -1.5708f;
            this.legBackLeft.func_78793_a(3.5f, 23.0f, 2.0f);
            this.legFrontRight.field_78795_f = -0.436332f;
            this.legFrontLeft.field_78795_f = -0.436332f;
        }
    }

    public void setupAnim(FennecFoxEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entityIn.func_70608_bn() || entityIn.func_213472_dX() || entityIn.func_213453_ef())) {
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        }
        if (entityIn.func_70608_bn()) {
            this.head.field_78795_f = 0.0f;
            this.head.field_78796_g = -2.0943952f;
            this.head.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks * 0.027f)) / 22.0f;
        }
        if (entityIn.func_213453_ef()) {
            float f;
            this.body.field_78796_g = f = MathHelper.func_76134_b((float)ageInTicks) * 0.01f;
            this.legBackRight.field_78808_h = f;
            this.legBackLeft.field_78808_h = f;
            this.legFrontRight.field_78808_h = f / 2.0f;
            this.legFrontLeft.field_78808_h = f / 2.0f;
        }
        if (entityIn.func_213472_dX()) {
            this.legMotion += 0.67f;
            this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(this.legMotion * 0.4662f)) * 0.1f;
            this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(this.legMotion * 0.4662f + (float)Math.PI)) * 0.1f;
            this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(this.legMotion * 0.4662f + (float)Math.PI)) * 0.1f;
            this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(this.legMotion * 0.4662f)) * 0.1f;
        }
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

