/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity;

import com.minecraftabnormals.environmental.core.EnvironmentalConfig;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEffects;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalSounds;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class KoiEntity
extends AbstractFishEntity {
    public KoiEntity(EntityType<? extends AbstractFishEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.4f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 4.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 5.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 50));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d vector3d = this.func_213322_ci();
        this.field_70125_A = (double)MathHelper.func_76135_e((float)((float)vector3d.field_72448_b)) >= 0.01 ? (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)MathHelper.func_76133_a((double)KoiEntity.func_213296_b((Vector3d)vector3d))) * 57.2957763671875) : 0.0f;
        this.field_70125_A = KoiEntity.normalizeRotation(this.field_70127_C, this.field_70125_A);
    }

    protected static float normalizeRotation(float prevRot, float rot) {
        while (rot - prevRot < -180.0f) {
            prevRot -= 360.0f;
        }
        while (rot - prevRot >= 180.0f) {
            prevRot += 360.0f;
        }
        return MathHelper.func_219799_g((float)0.2f, (float)prevRot, (float)rot);
    }

    public void func_70636_d() {
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.45f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.func_203701_dz(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70170_p.func_82737_E() % 20L == 0L && ((Boolean)EnvironmentalConfig.COMMON.serenityEffect.get()).booleanValue()) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (PlayerEntity player : this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (this.field_70170_p.func_201670_d()) continue;
                player.func_195064_c(new EffectInstance((Effect)EnvironmentalEffects.SERENITY.get(), 100, 0, false, false));
            }
        }
        super.func_70636_d();
    }

    public SoundEvent func_203701_dz() {
        return (SoundEvent)EnvironmentalSounds.KOI_FLOP.get();
    }

    public SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    public ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)EnvironmentalItems.KOI_BUCKET.get());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    public static boolean canKoiSpawn(EntityType<? extends AbstractFishEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150355_j) && pos.func_177956_o() > 55;
    }

    static class MoveHelperController
    extends MovementController {
        private final KoiEntity koi;

        public MoveHelperController(KoiEntity koi) {
            super((MobEntity)koi);
            this.koi = koi;
        }

        public void func_75641_c() {
            if (this.koi.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.koi.func_213317_d(this.koi.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.koi.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.koi.func_226277_ct_();
                double d1 = this.field_75647_c - this.koi.func_226278_cu_();
                double d2 = this.field_75644_d - this.koi.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                if (d0 != 0.0 || (d1 /= d3) != 0.0) {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.koi.field_70761_aq = this.koi.field_70177_z = this.func_75639_a(this.koi.field_70177_z, f, 15.0f);
                    this.koi.field_70759_as = this.koi.field_70177_z;
                }
                float f1 = (float)(this.field_75645_e * this.koi.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.koi.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.koi.func_70689_ay(), (float)f1));
                this.koi.func_213317_d(this.koi.func_213322_ci().func_72441_c(0.0, (double)this.koi.func_70689_ay() * d1 * 0.03, 0.0));
            }
        }
    }
}

