/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity.util;

import net.minecraft.util.text.TextFormatting;

public enum SlabfishRarity {
    COMMON(TextFormatting.GRAY, 1.0f),
    UNCOMMON(TextFormatting.GREEN, 0.55f),
    RARE(TextFormatting.AQUA, 0.15f),
    EPIC(TextFormatting.LIGHT_PURPLE, 0.08f),
    LEGENDARY(TextFormatting.GOLD, 0.02f);

    private final TextFormatting color;
    private final float chance;

    private SlabfishRarity(TextFormatting color, float chance) {
        this.color = color;
        this.chance = chance;
    }

    public TextFormatting getFormatting() {
        return this.color;
    }

    public float getChance() {
        return this.chance;
    }

    public static SlabfishRarity byChance(float chance) {
        for (int i = SlabfishRarity.values().length - 1; i > 0; --i) {
            if (!(chance <= SlabfishRarity.values()[i].getChance())) continue;
            return SlabfishRarity.values()[i];
        }
        return COMMON;
    }

    public static SlabfishRarity byId(int id) {
        if (id < 0 || id >= SlabfishRarity.values().length) {
            return COMMON;
        }
        return SlabfishRarity.values()[id];
    }
}

