/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.inventory.container;

import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.minecraftabnormals.environmental.common.inventory.SlabfishInventory;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalContainers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;

public class SlabfishInventoryContainer
extends Container {
    private static final ResourceLocation[] SLOT_INDEX_NAMES = new ResourceLocation[]{new ResourceLocation("environmental", "item/slabfish_sweater_slot"), new ResourceLocation("environmental", "item/slabfish_backpack_slot"), new ResourceLocation("environmental", "item/slabfish_backpack_type_slot")};
    private final IInventory slabfishInventory;
    private final SlabfishEntity slabfish;

    public SlabfishInventoryContainer(int windowId, PlayerInventory playerInventory, final @Nullable SlabfishInventory slabfishInventory, final @Nullable SlabfishEntity slabfish) {
        super((ContainerType)EnvironmentalContainers.SLABFISH_INVENTORY.get(), windowId);
        this.slabfishInventory = slabfishInventory;
        this.slabfish = slabfish;
        if (slabfishInventory != null && slabfish != null) {
            slabfishInventory.func_174889_b(playerInventory.field_70458_d);
            for (int i = 0; i < 3; ++i) {
                this.func_75146_a(new Slot(slabfishInventory, i, 8, 18 + i * 18){

                    public boolean func_75214_a(ItemStack stack) {
                        return slabfishInventory.func_94041_b(this.getSlotIndex(), stack);
                    }

                    public int func_75219_a() {
                        return slabfishInventory.getSlotStackLimit(this.getSlotIndex());
                    }

                    public boolean func_111238_b() {
                        if (this.getSlotIndex() != 2) {
                            return true;
                        }
                        SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)slabfish.func_130014_f_());
                        SlabfishType slabfishType = slabfishManager.getSlabfishType(slabfish.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH);
                        return slabfish.hasBackpack() && (slabfishType.getCustomBackpack() == null || !slabfishManager.getBackpackType(slabfishType.getCustomBackpack()).isPresent());
                    }
                }).setBackground(PlayerContainer.field_226615_c_, SLOT_INDEX_NAMES[i]);
            }
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < 5; ++l) {
                    this.func_75146_a(new Slot(slabfishInventory, 3 + l + k * 5, 80 + l * 18, 18 + k * 18){

                        public boolean func_111238_b() {
                            return slabfish.hasBackpack();
                        }
                    });
                }
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, k1 + i1 * 9 + 9, 8 + k1 * 18, 102 + i1 * 18 + -18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, j1, 8 + j1 * 18, 142));
        }
    }

    public SlabfishInventoryContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, null, null);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.slabfishInventory.func_70300_a(player) && this.slabfish.func_70089_S() && this.slabfish.func_70032_d((Entity)player) < 8.0f;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemstack = slotStack.func_77946_l();
            int i = this.slabfishInventory.func_70302_i_();
            if (index < i) {
                if (!this.func_75135_a(slotStack, i, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (this.func_75139_a(0).func_75214_a(slotStack) && !this.func_75139_a(0).func_75216_d() && !this.func_75135_a(slotStack, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (this.func_75139_a(1).func_75214_a(slotStack) && !this.func_75139_a(1).func_75216_d() && !this.func_75135_a(slotStack, 1, 2, false)) {
                    return ItemStack.field_190927_a;
                }
                if (this.func_75139_a(2).func_75214_a(slotStack) && !this.func_75139_a(2).func_75216_d() && !this.func_75135_a(slotStack, 2, 3, false)) {
                    return ItemStack.field_190927_a;
                }
                if (i <= 3 || !this.func_75135_a(slotStack, 3, i, false)) {
                    int firstInvSlot = 18;
                    int firstHotbarSlot = 45;
                    int lastHotbarSlot = 53;
                    if (index >= firstHotbarSlot && index <= lastHotbarSlot ? !this.func_75135_a(slotStack, firstInvSlot, firstHotbarSlot, false) : index >= i && index < firstHotbarSlot && !this.func_75135_a(slotStack, firstHotbarSlot, lastHotbarSlot + 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                }
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        --this.slabfish.playersUsing;
        this.slabfishInventory.func_174886_c(player);
    }
}

