/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.item.explorer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.minecraftabnormals.environmental.client.model.ArchitectBeltModel;
import com.minecraftabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class ArchitectBeltItem
extends ExplorerArmorItem {
    private static final String NBT_TAG = "ArchitectBeltUses";

    public ArchitectBeltItem(Item.Properties properties) {
        super(EquipmentSlotType.LEGS, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        return ArchitectBeltModel.get(1.0f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.func_111205_h(this.func_185083_B_()));
        UUID uuid = UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D");
        int uses = stack.func_77978_p().func_74762_e(NBT_TAG);
        int increase = this.getIncreaseForUses(uses);
        builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(uuid, "Reach modifier", (double)increase, AttributeModifier.Operation.ADDITION));
        return slot == this.field_77881_a ? builder.build() : super.func_111205_h(slot);
    }

    @SubscribeEvent
    public static void placeBlockEvent(BlockEvent.EntityPlaceEvent event) {
        PlayerEntity player;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        BlockState state = event.getState();
        if (entity instanceof PlayerEntity && !state.func_203425_a(Blocks.field_185778_de) && (item = (stack = (player = (PlayerEntity)entity).func_184582_a(EquipmentSlotType.LEGS)).func_77973_b()) instanceof ArchitectBeltItem) {
            ((ArchitectBeltItem)item).levelUp(stack, (LivingEntity)player);
        }
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 100, 500, 1000, 2500};
    }
}

