/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish;

import com.minecraftabnormals.environmental.common.network.message.SSyncBackpackTypeMessage;
import com.minecraftabnormals.environmental.common.network.message.SSyncSlabfishTypeMessage;
import com.minecraftabnormals.environmental.common.network.message.SSyncSweaterTypeMessage;
import com.minecraftabnormals.environmental.common.slabfish.BackpackType;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.common.slabfish.SweaterType;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class ClientSlabfishManager
implements SlabfishManager {
    static final ClientSlabfishManager INSTANCE = new ClientSlabfishManager();
    private final Map<ResourceLocation, SlabfishType> slabfishTypes = new HashMap<ResourceLocation, SlabfishType>();
    private final Map<ResourceLocation, SweaterType> sweaterTypes = new HashMap<ResourceLocation, SweaterType>();
    private final Map<ResourceLocation, BackpackType> backpackTypes = new HashMap<ResourceLocation, BackpackType>();

    private ClientSlabfishManager() {
    }

    public static void receive(SSyncSlabfishTypeMessage msg) {
        ClientSlabfishManager.INSTANCE.slabfishTypes.clear();
        ClientSlabfishManager.INSTANCE.slabfishTypes.putAll(Arrays.stream(msg.getSlabfishTypes()).collect(Collectors.toMap(SlabfishType::getRegistryName, slabfishType -> slabfishType)));
    }

    public static void receive(SSyncSweaterTypeMessage msg) {
        ClientSlabfishManager.INSTANCE.sweaterTypes.clear();
        ClientSlabfishManager.INSTANCE.sweaterTypes.putAll(Arrays.stream(msg.getSweaterTypes()).collect(Collectors.toMap(SweaterType::getRegistryName, sweaterType -> sweaterType)));
    }

    public static void receive(SSyncBackpackTypeMessage msg) {
        ClientSlabfishManager.INSTANCE.backpackTypes.clear();
        ClientSlabfishManager.INSTANCE.backpackTypes.putAll(Arrays.stream(msg.getBackpackTypes()).collect(Collectors.toMap(BackpackType::getRegistryName, backpackType -> backpackType)));
    }

    @Override
    public Optional<SlabfishType> getSlabfishType(ResourceLocation registryName) {
        return Optional.ofNullable(this.slabfishTypes.get(registryName));
    }

    @Override
    public Optional<SweaterType> getSweaterType(ResourceLocation registryName) {
        return Optional.ofNullable(this.sweaterTypes.get(registryName));
    }

    @Override
    public Optional<BackpackType> getBackpackType(ResourceLocation registryName) {
        return Optional.ofNullable(this.backpackTypes.get(registryName));
    }

    @Override
    public Optional<SlabfishType> getSlabfishType(Predicate<SlabfishType> predicate, SlabfishConditionContext context) {
        throw new UnsupportedOperationException("Client does not have access to select random slabfish");
    }

    @Override
    public Optional<SweaterType> getSweaterType(ItemStack stack) {
        return this.sweaterTypes.values().stream().filter(sweaterType -> sweaterType.test(stack)).findFirst();
    }

    @Override
    public Optional<BackpackType> getBackpackType(ItemStack stack) {
        return this.backpackTypes.values().stream().filter(backpackType -> backpackType.test(stack)).findFirst();
    }

    @Override
    public Optional<SlabfishType> getRandomSlabfishType(Predicate<SlabfishType> predicate, Random random) {
        throw new UnsupportedOperationException("Client does not have access to select random slabfish");
    }

    @Override
    public SlabfishType[] getAllSlabfishTypes() {
        return this.slabfishTypes.values().toArray(new SlabfishType[0]);
    }

    @Override
    public SweaterType[] getAllSweaterTypes() {
        return this.sweaterTypes.values().toArray(new SweaterType[0]);
    }

    @Override
    public BackpackType[] getAllBackpackTypes() {
        return this.backpackTypes.values().toArray(new BackpackType[0]);
    }
}

