/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.environmental.common.entity.util.SlabfishRarity;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

public class SlabfishType
implements Predicate<SlabfishConditionContext> {
    private final boolean translucent;
    private final ResourceLocation customBackpack;
    private final SlabfishRarity rarity;
    private final boolean tradable;
    private final boolean modLoaded;
    private final int priority;
    private final SlabfishCondition[] conditions;
    private final LazyValue<ResourceLocation> textureLocation = new LazyValue(() -> new ResourceLocation(this.getRegistryName().func_110624_b(), "type/" + this.getRegistryName().func_110623_a()));
    private ResourceLocation registryName;
    private ITextComponent displayName;

    public SlabfishType(SlabfishRarity rarity, @Nullable ITextComponent displayName, @Nullable ResourceLocation customBackpack, boolean translucent, boolean tradable, boolean modLoaded, int priority, SlabfishCondition[] conditions) {
        this.rarity = rarity;
        this.displayName = displayName;
        this.customBackpack = customBackpack;
        this.translucent = translucent;
        this.tradable = tradable;
        this.modLoaded = modLoaded;
        this.priority = priority;
        this.conditions = conditions;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SlabfishType readFrom(PacketBuffer buf) {
        ResourceLocation registryName = buf.func_192575_l();
        ITextComponent displayName = buf.func_179258_d();
        ResourceLocation customBackpack = buf.readBoolean() ? buf.func_192575_l() : null;
        boolean translucent = buf.readBoolean();
        SlabfishRarity rarity = SlabfishRarity.byId(buf.func_150792_a());
        boolean modLoaded = buf.readBoolean();
        int priority = buf.func_150792_a();
        return new SlabfishType(rarity, displayName, customBackpack, translucent, false, modLoaded, priority, new SlabfishCondition[0]).setRegistryName(registryName);
    }

    @Override
    public boolean test(SlabfishConditionContext slabfishEntity) {
        for (SlabfishCondition condition : this.conditions) {
            if (condition.test(slabfishEntity)) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    SlabfishType setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        if (this.displayName == null) {
            this.displayName = new StringTextComponent(registryName.toString());
        }
        return this;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.func_179281_c();
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    @Nullable
    public ResourceLocation getCustomBackpack() {
        return this.customBackpack;
    }

    public SlabfishRarity getRarity() {
        return this.rarity;
    }

    public boolean isTradable() {
        return this.tradable;
    }

    public boolean isModLoaded() {
        return this.modLoaded;
    }

    public int getPriority() {
        return this.priority;
    }

    public void writeTo(PacketBuffer buf) {
        buf.func_192572_a(this.registryName);
        buf.func_179256_a(this.displayName);
        buf.writeBoolean(this.customBackpack != null);
        if (this.customBackpack != null) {
            buf.func_192572_a(this.customBackpack);
        }
        buf.writeBoolean(this.translucent);
        buf.func_150787_b(this.rarity.ordinal());
        buf.writeBoolean(this.modLoaded);
        buf.func_150787_b(this.priority);
    }

    public String toString() {
        return "SlabfishType{registryName=" + this.registryName + ", displayName=" + this.displayName.getString() + ", rarity=" + (Object)((Object)this.rarity) + ", modLoaded=" + this.modLoaded + ", priority=" + this.priority + '}';
    }

    public static class Deserializer
    implements JsonDeserializer<SlabfishType> {
        private static SlabfishRarity deserializeRarity(JsonElement element) throws JsonParseException {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonSyntaxException("'rarity' expected to be a string");
            }
            String name = element.getAsString();
            for (SlabfishRarity rarity : SlabfishRarity.values()) {
                if (!rarity.name().equalsIgnoreCase(name)) continue;
                return rarity;
            }
            throw new JsonSyntaxException("Invalid slabfish rarity: " + name);
        }

        public SlabfishType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (!jsonObject.has("rarity")) {
                throw new JsonSyntaxException("'rarity' is required");
            }
            SlabfishRarity rarity = Deserializer.deserializeRarity(jsonObject.get("rarity"));
            ITextComponent displayName = jsonObject.has("displayName") ? (ITextComponent)context.deserialize(jsonObject.get("displayName"), ITextComponent.class) : null;
            ResourceLocation customBackpack = jsonObject.has("customBackpack") ? (ResourceLocation)context.deserialize(jsonObject.get("customBackpack"), ResourceLocation.class) : null;
            boolean translucent = jsonObject.has("translucent") && jsonObject.get("translucent").getAsBoolean();
            boolean tradable = !jsonObject.has("tradable") || jsonObject.get("tradable").getAsBoolean();
            boolean modLoaded = !jsonObject.has("mod") || ModList.get().isLoaded(jsonObject.get("mod").getAsString());
            int priority = jsonObject.has("priority") ? jsonObject.get("priority").getAsInt() : 0;
            SlabfishCondition[] conditions = jsonObject.has("conditions") ? (SlabfishCondition[])context.deserialize(jsonObject.get("conditions"), SlabfishCondition[].class) : new SlabfishCondition[]{};
            return new SlabfishType(rarity, displayName, customBackpack, translucent, tradable, modLoaded, priority, conditions);
        }
    }
}

