/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface SlabfishCondition
extends Predicate<SlabfishConditionContext> {
    @Override
    public boolean test(SlabfishConditionContext var1);

    public static interface Factory
    extends IForgeRegistryEntry<Factory> {
        public SlabfishCondition create(JsonObject var1, JsonDeserializationContext var2) throws JsonParseException;
    }

    public static class Deserializer
    implements JsonDeserializer<SlabfishCondition> {
        public SlabfishCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (!jsonObject.has("type")) {
                throw new JsonSyntaxException("Slabfish condition type is required");
            }
            ResourceLocation type = (ResourceLocation)context.deserialize(jsonObject.get("type"), ResourceLocation.class);
            if (!EnvironmentalRegistries.SLABFISH_CONDITIONS.containsKey(type)) {
                throw new JsonSyntaxException("Invalid slabfish condition type: " + type);
            }
            Factory factory = (Factory)EnvironmentalRegistries.SLABFISH_CONDITIONS.getValue(type);
            if (factory == null) {
                throw new JsonSyntaxException("Invalid slabfish condition type: " + type);
            }
            return factory.create(jsonObject, context);
        }
    }
}

