/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minecraftabnormals.environmental.common.item.crafting.BakingRecipe;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.minecraftabnormals.environmental.integration.jei.EnvironmentalPlugin;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class BakingCategory
implements IRecipeCategory<BakingRecipe> {
    public static final ResourceLocation BAKING = new ResourceLocation("environmental", "baking");
    private final IDrawableAnimated animatedFlame;
    protected final LoadingCache<BakingRecipe, IDrawableAnimated> cachedArrows;
    private static final int inputSlot = 0;
    private static final int outputSlot = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public BakingCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(EnvironmentalPlugin.RECIPE_GUI_ENVIRONMENTAL, 0, 114, 82, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)EnvironmentalBlocks.KILN.get()));
        this.localizedName = I18n.func_135052_a((String)"gui.environmental.category.baking", (Object[])new Object[0]);
        IDrawableStatic staticFlame = guiHelper.createDrawable(EnvironmentalPlugin.RECIPE_GUI_ENVIRONMENTAL, 82, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<BakingRecipe, IDrawableAnimated>(){

            public IDrawableAnimated load(BakingRecipe key) {
                int cookTime = key.func_222137_e();
                if (cookTime <= 0) {
                    cookTime = 100;
                }
                return guiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 82, 128, 24, 17).buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public void draw(BakingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(matrixStack, 1, 20);
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)recipe);
        arrow.draw(matrixStack, 24, 18);
        this.drawExperience(recipe, matrixStack, 0);
        this.drawCookTime(recipe, matrixStack, 45);
    }

    protected void drawExperience(BakingRecipe recipe, MatrixStack matrixStack, int y) {
        float experience = recipe.func_222138_b();
        if (experience > 0.0f) {
            TranslationTextComponent experienceString = new TranslationTextComponent("gui.jei.category.smelting.experience", new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)experienceString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)experienceString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawCookTime(BakingRecipe recipe, MatrixStack matrixStack, int y) {
        int cookTime = recipe.func_222137_e();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category.smelting.time.seconds", new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public ResourceLocation getUid() {
        return BAKING;
    }

    public Class<? extends BakingRecipe> getRecipeClass() {
        return BakingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BakingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, BakingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

