/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class ScrollableListWidget<T>
extends ExtendedButton {
    private static final ResourceLocation MISC = new ResourceLocation("teamlapenlib", "textures/gui/misc.png");
    protected final List<ListItem<T>> listItems = new ArrayList<ListItem<T>>();
    private final ItemCreator<T> itemSupplier;
    private final int itemHeight;
    private final int scrollerWidth = 9;
    private final Supplier<Collection<T>> baseValueSupplier;
    private int scrolled;
    private double scrolledD;
    private boolean scrollerClicked;
    private boolean canScroll = true;
    private double scrollSpeed = 1.0;

    public ScrollableListWidget(int xPos, int yPos, int width, int height, int itemHeight, @Nonnull Supplier<Collection<T>> baseValueSupplier, @Nonnull ItemCreator<T> itemSupplier) {
        super(xPos, yPos, width, height, (ITextComponent)new StringTextComponent(""), button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
        this.baseValueSupplier = baseValueSupplier;
        this.refresh();
    }

    public ScrollableListWidget(int xPos, int yPos, int width, int height, int itemHeight, @Nonnull Supplier<Collection<T>> baseValueSupplier, @Nonnull ItemCreator<T> itemSupplier, ITextComponent name) {
        super(xPos, yPos, width, height, name, button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
        this.baseValueSupplier = baseValueSupplier;
        this.refresh();
    }

    public void addItem(@Nonnull T element) {
        this.listItems.add(this.itemSupplier.apply(element, this));
        this.setCanScroll();
    }

    public boolean isEmpty() {
        return this.listItems.isEmpty();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.field_230694_p_) {
            return false;
        }
        this.scrolledD = this.scrolled;
        if (mouseX > (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY > (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_)) {
            if (mouseX > (double)(this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth)) {
                this.scrollerClicked = true;
            } else {
                for (int i = 0; i < this.listItems.size(); ++i) {
                    int y = i * this.itemHeight - this.scrolled;
                    if (y < -this.itemHeight) continue;
                    ListItem<T> item = this.listItems.get(i);
                    if (!(mouseX > (double)(this.field_230690_l_ + 1)) || !(mouseX < (double)(this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth)) || !(mouseY > (double)(this.field_230691_m_ + 1 + y)) || !(mouseY < (double)(this.field_230691_m_ + 1 + y + this.itemHeight)) || !item.onClick(mouseX, mouseY)) continue;
                    return true;
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.field_230694_p_ && this.canScroll && this.scrollerClicked) {
            double perc = dragY / (double)(this.field_230689_k_ - 27);
            double s = (double)(this.listItems.size() * this.itemHeight - this.field_230689_k_) * perc;
            this.scrolledD += s;
            this.scrolled = (int)this.scrolledD;
            this.scrolled = MathHelper.func_76125_a((int)this.scrolled, (int)0, (int)(this.listItems.size() * this.itemHeight - this.field_230689_k_ + 2));
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.scrollerClicked = false;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!this.field_230694_p_) {
            return false;
        }
        if (this.canScroll) {
            this.scrolled = MathHelper.func_76125_a((int)(this.scrolled + 4 * (int)(-(delta * this.scrollSpeed))), (int)0, (int)(this.listItems.size() * this.itemHeight - this.field_230689_k_ + 2));
            this.scrolledD = this.scrolled;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.setItems(this.baseValueSupplier.get());
    }

    public void removeItem(T element) {
        this.listItems.removeIf(item -> item.item == element);
        this.setCanScroll();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_230694_p_) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListWidget.func_238467_a_((MatrixStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.depthFunc((int)518);
        matrixStack.func_227861_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 0.0);
        ScrollableListWidget.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)0, (int)0, (int)-16711680);
        matrixStack.func_227861_a_((double)(-this.field_230690_l_), (double)(-this.field_230691_m_), 0.0);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.renderItems(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)518);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListWidget.func_238467_a_((MatrixStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
        this.func_230443_a_(matrixStack, mouseX, mouseY);
    }

    public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (mouseX > this.field_230690_l_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY > this.field_230691_m_ && mouseY < this.field_230691_m_ + this.field_230689_k_ + 1) {
            int itemHeight = this.itemHeight;
            for (int i = 0; i < this.listItems.size(); ++i) {
                int y = i * itemHeight - this.scrolled;
                if (y < -itemHeight) continue;
                ListItem<T> item = this.listItems.get(i);
                item.preRenderToolTip(matrixStack, this.field_230690_l_, this.field_230691_m_ + y + 1, this.field_230688_j_ - 9, this.field_230689_k_, this.itemHeight, mouseX, mouseY, this.func_230927_p_());
            }
        }
    }

    public ScrollableListWidget<T> scrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
        return this;
    }

    public void setItems(@Nonnull Collection<T> elements) {
        this.listItems.clear();
        elements.forEach(item -> this.listItems.add(this.itemSupplier.apply(item, this)));
        this.setScrolled(0);
        this.setCanScroll();
    }

    protected void addItem(@Nonnull ListItem<T> newElement, @Nonnull ListItem<T> afterElement) {
        this.listItems.add(this.listItems.indexOf(afterElement) + 1, newElement);
        this.setCanScroll();
    }

    protected void removeItem(ListItem<T> item) {
        this.listItems.remove(item);
        this.setCanScroll();
    }

    private void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)new ResourceLocation("textures/gui/widgets.png"), (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (int)46, (int)(this.field_230688_j_ - this.scrollerWidth + 1), (int)this.field_230689_k_, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)this.func_230927_p_());
    }

    private void renderItems(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int itemHeight = this.itemHeight;
        for (int i = 0; i < this.listItems.size(); ++i) {
            int y = i * itemHeight - this.scrolled;
            ListItem<T> item = this.listItems.get(i);
            item.render(matrixStack, this.field_230690_l_ + 1, this.field_230691_m_ + 1 + y, this.field_230688_j_ - 9 - 1, this.field_230689_k_, this.itemHeight, mouseX, mouseY, partialTicks, this.func_230927_p_());
        }
        this.renderScrollBar(matrixStack, mouseX, mouseY, partialTicks);
        this.func_238465_a_(matrixStack, this.field_230690_l_, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_, -16777216);
        this.func_238465_a_(matrixStack, this.field_230690_l_, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + this.field_230689_k_ - 1, -16777216);
    }

    private void renderScrollBar(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)MISC, (int)(this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth), (int)this.field_230691_m_, (int)0, (int)0, (int)9, (int)this.field_230689_k_, (int)9, (int)200, (int)2, (float)this.func_230927_p_());
        this.renderScroller(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScroller(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int scrollerHeight = 27;
        int scrollHeight = this.field_230689_k_ - 2 - scrollerHeight;
        float perc = (float)this.scrolled / (float)(this.listItems.size() * this.itemHeight - this.field_230689_k_ + 2);
        int yOffset = (int)((float)scrollHeight * perc);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MISC);
        this.func_238474_b_(matrixStack, this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth + 1, this.field_230691_m_ + yOffset + 1, this.canScroll ? 9 : 16, 0, 7, 27);
    }

    private void setCanScroll() {
        this.canScroll = this.listItems.size() * this.itemHeight > this.field_230689_k_;
    }

    private void setScrolled(int scrolled) {
        this.scrolled = scrolled;
        this.scrolledD = this.scrolled;
    }

    public static abstract class ListItem<T> {
        private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        @Nonnull
        protected final T item;
        @Nonnull
        protected final ScrollableListWidget<T> list;

        public ListItem(@Nonnull T item, @Nonnull ScrollableListWidget<T> list) {
            this.item = item;
            this.list = list;
        }

        public boolean onClick(double mouseX, double mouseY) {
            return false;
        }

        public void preRenderToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
            int ySize = MathHelper.func_76125_a((int)listHeight, (int)0, (int)itemHeight);
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + ySize) {
                this.renderToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            }
        }

        public void render(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            int v = 66;
            if (mouseX >= x && mouseX < x + listWidth && mouseY >= y && mouseY < y + itemHeight) {
                v = 86;
            }
            RenderSystem.enableDepthTest();
            GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)WIDGETS, (int)x, (int)y, (int)0, (int)v, (int)(listWidth + 1), (int)itemHeight, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)zLevel);
            RenderSystem.disableDepthTest();
        }

        public void renderToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        }
    }

    @FunctionalInterface
    public static interface ItemCreator<T> {
        public ListItem<T> apply(@Nonnull T var1, @Nonnull ScrollableListWidget<T> var2);
    }
}

