/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.brigadier.CommandDispatcher;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.config.BloodValueLoaderDynamic;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.ModCompatLoader;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.GeneralEventHandler;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.config.BloodValues;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModCommands;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.data.AdvancementGenerator;
import de.teamlapen.vampirism.data.BlockStateGenerator;
import de.teamlapen.vampirism.data.ItemModelGenerator;
import de.teamlapen.vampirism.data.LootTablesGenerator;
import de.teamlapen.vampirism.data.RecipesGenerator;
import de.teamlapen.vampirism.data.SkillNodeGenerator;
import de.teamlapen.vampirism.data.TagGenerator;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.VampirismEntitySelectors;
import de.teamlapen.vampirism.entity.action.ActionManagerEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.inventory.recipes.ExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.player.actions.ActionManager;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.skills.SkillManager;
import de.teamlapen.vampirism.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.player.vampire.BloodVision;
import de.teamlapen.vampirism.player.vampire.NightVision;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.proxy.ServerProxy;
import de.teamlapen.vampirism.sit.SitHandler;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.HunterVillageData;
import de.teamlapen.vampirism.util.LordTitles;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.util.VampireVillageData;
import de.teamlapen.vampirism.world.VampirismWorld;
import de.teamlapen.vampirism.world.WorldGenManager;
import de.teamlapen.vampirism.world.biome.VampireForestBiome;
import de.teamlapen.vampirism.world.gen.VampirismWorldGen;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityClassification;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vampirism")
public class VampirismMod {
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final ItemGroup creativeTab = new ItemGroup("vampirism"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.VAMPIRE_FANG.get());
        }
    };
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityClassification HUNTER_CREATURE_TYPE = EntityClassification.create((String)"vampirism_hunter", (String)"vampirism_hunter", (int)25, (boolean)false, (boolean)false, (int)128);
    private static final EntityClassification VAMPIRE_CREATURE_TYPE = EntityClassification.create((String)"vampirism_vampire", (String)"vampirism_vampire", (int)30, (boolean)false, (boolean)false, (int)128);
    private static final CreatureAttribute VAMPIRE_CREATURE_ATTRIBUTE = new CreatureAttribute();
    public static VampirismMod instance;
    public static IProxy proxy;
    public static boolean inDev;
    public static boolean inDataGen;
    public final ModCompatLoader modCompatLoader = new ModCompatLoader();
    private final RegistryManager registryManager;
    private VersionChecker.VersionInfo versionInfo;

    public static boolean isRealism() {
        return false;
    }

    public VampirismMod() {
        instance = this;
        this.checkEnv();
        Optional opt = ModList.get().getModContainerById("vampirism");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(this::setup);
        modbus.addListener(this::enqueueIMC);
        modbus.addListener(this::processIMC);
        modbus.addListener(this::loadComplete);
        modbus.addListener(this::gatherData);
        modbus.addGenericListener(Block.class, this::finalizeConfiguration);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modbus.addListener(ClientEventHandler::onModelBakeEvent);
            modbus.addListener(this::setupClient);
            modbus.addListener(ClientEventHandler::onModelRegistry);
        });
        VampirismConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addModCompats();
        this.registryManager = new RegistryManager();
        modbus.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModBiomes::onBiomeLoadingEventAdditions);
        MinecraftForge.EVENT_BUS.addListener(VampireForestBiome::addFeatures);
        MinecraftForge.EVENT_BUS.register(SitHandler.class);
        this.prepareAPI();
        RegistryManager.setupRegistries(modbus);
        if (OptifineHandler.isOptifineLoaded()) {
            LOGGER.warn("Using Optifine. Expect visual glitches and reduces blood vision functionality if using shaders.");
        }
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @SubscribeEvent
    public void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        SkillTreeManager.getInstance().getSkillTree().initRootSkills();
        event.addListener((IFutureReloadListener)SkillTreeManager.getInstance());
        event.addListener((IFutureReloadListener)new BloodValues());
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        VampirismWorldGen.addVillageStructures(event.getServer().func_244267_aX());
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartingEvent event) {
        for (BloodValueLoaderDynamic loader : BloodValues.getDynamicLoader()) {
            loader.onServerStarting(event.getServer());
        }
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        int missing = ModLootTables.checkAndResetInsertedAll();
        if (missing > 0) {
            LOGGER.warn("LootTables Failed to inject {} loottables", (Object)missing);
        }
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        for (BloodValueLoaderDynamic loader : BloodValues.getDynamicLoader()) {
            loader.onServerStopping();
        }
    }

    private void addModCompats() {
    }

    private void checkEnv() {
        String launchTarget = System.getenv().get("target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
        if (launchTarget != null && launchTarget.contains("data")) {
            inDataGen = true;
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        HelperRegistry.registerPlayerEventReceivingCapability(VampirePlayer.CAP, VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability(HunterPlayer.CAP, HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability(ExtendedCreature.CAP, REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability(VampirePlayer.CAP, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(HunterPlayer.CAP, REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(FactionPlayerHandler.CAP, REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.class);
    }

    private void finalizeConfiguration(RegistryEvent<Block> event) {
        VampirismConfig.finalizeAndRegisterConfig();
    }

    private void finishAPI() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).finishRegistration();
    }

    private void gatherData(GatherDataEvent event) {
        this.registryManager.onGatherData(event);
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            TagGenerator.register(gen, event.getExistingFileHelper());
            gen.func_200390_a((IDataProvider)new LootTablesGenerator(gen));
            gen.func_200390_a((IDataProvider)new AdvancementGenerator(gen));
            gen.func_200390_a((IDataProvider)new RecipesGenerator(gen));
            gen.func_200390_a((IDataProvider)new SkillNodeGenerator(gen));
        }
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new BlockStateGenerator(event.getGenerator(), event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new ItemModelGenerator(event.getGenerator(), event.getExistingFileHelper()));
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        VampirismAPI.skillManager().registerSkillType(SkillType.LEVEL);
        VampirismAPI.skillManager().registerSkillType(SkillType.LORD);
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> VampirismLogger::init);
    }

    private void prepareAPI() {
        FactionRegistry factionRegistry = new FactionRegistry();
        SundamageRegistry sundamageRegistry = new SundamageRegistry();
        VampirismEntityRegistry biteableRegistry = new VampirismEntityRegistry();
        ActionManager actionManager = new ActionManager();
        SkillManager skillManager = new SkillManager();
        GeneralRegistryImpl generalRegistry = new GeneralRegistryImpl();
        ActionManagerEntity entityActionManager = new ActionManagerEntity();
        WorldGenManager worldGenRegistry = new WorldGenManager();
        ExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry = new ExtendedBrewingRecipeRegistry();
        biteableRegistry.setDefaultConvertingHandlerCreator(DefaultConvertingHandler::new);
        VampirismAPI.setUpRegistries(factionRegistry, sundamageRegistry, biteableRegistry, actionManager, skillManager, generalRegistry, entityActionManager, worldGenRegistry, extendedBrewingRecipeRegistry);
        VReference.VAMPIRE_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.VAMPIRE_PLAYER_KEY, IVampirePlayer.class, () -> VampirePlayer.CAP).color(Color.MAGENTA.darker().darker()).chatColor(TextFormatting.DARK_PURPLE).name("text.vampirism.vampire").namePlural("text.vampirism.vampires").hostileTowardsNeutral().highestLevel(14).lordLevel(5).lordTitle(LordTitles::getVampireTitle).village(VampireVillageData::vampireVillage).refinementItems(VampireRefinementItem::getItemForType).enableLordSkills().register();
        VReference.HUNTER_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.HUNTER_PLAYER_KEY, IHunterPlayer.class, () -> HunterPlayer.CAP).color(Color.BLUE).chatColor(TextFormatting.BLUE).name("text.vampirism.hunter").namePlural("text.vampirism.hunters").highestLevel(14).lordLevel(5).lordTitle(LordTitles::getHunterTitle).village(HunterVillageData::hunterVillage).enableLordSkills().register();
        VReference.HUNTER_CREATURE_TYPE = HUNTER_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_TYPE = VAMPIRE_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_ATTRIBUTE = VAMPIRE_CREATURE_ATTRIBUTE;
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision("nightVision", new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision("bloodVision", new BloodVision());
        VampirismAPI.onSetupComplete();
    }

    private void processIMC(InterModProcessEvent event) {
        this.finishAPI();
        this.registryManager.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        IMCHandler.handleInterModMessage(event);
        if (inDev) {
            Tests.runBackgroundTests();
        }
        VampirismWorldGen.createJigsawPool();
    }

    private void setup(FMLCommonSetupEvent event) {
        HunterPlayer.registerCapability();
        VampirePlayer.registerCapability();
        FactionPlayerHandler.registerCapability();
        ExtendedCreature.registerCapability();
        VampirismWorld.registerCapability();
        this.modCompatLoader.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        dispatcher.registerPackets();
        this.registryManager.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        this.versionInfo = (Boolean)VampirismConfig.COMMON.versionCheck.get() == false ? new VersionChecker.VersionInfo(REFERENCE.VERSION) : VersionChecker.executeVersionCheck("https://maxanier.de/projects/vampirism/versions.json", REFERENCE.VERSION, !inDev && (Boolean)VampirismConfig.COMMON.collectStats.get() != false);
        GeneralEventHandler eventHandler = new GeneralEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        SupporterManager.getInstance().initAsync();
        VampireBookManager.getInstance().init();
        Permissions.init();
        VampirismEntitySelectors.registerSelectors();
    }

    private void setupClient(FMLClientSetupEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        inDev = false;
        inDataGen = false;
    }
}

