/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.mixin.PlayerAdvancementsAccessor;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TriggerFaction
extends AbstractCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "faction");
    private static final Logger LOGGER = LogManager.getLogger();

    public static Instance builder(@Nullable IPlayableFaction<?> faction, int level) {
        return new Instance(Type.LEVEL, faction, level);
    }

    public static Instance lord(@Nullable IPlayableFaction<?> faction, int lordLevel) {
        return new Instance(Type.LORD, faction, lordLevel);
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void trigger(ServerPlayerEntity playerMP, IPlayableFaction<?> faction, int level, int lordLevel) {
        this.func_235959_a_(playerMP, instance -> instance.test(faction, level, lordLevel));
    }

    public void revokeAll(ServerPlayerEntity player) {
        this.revoke(player, instance -> true);
    }

    public void revokeLevel(ServerPlayerEntity player, IPlayableFaction<?> faction, Type type, int newLevel) {
        this.revoke(player, instance -> ((Instance)instance).faction == faction && ((Instance)instance).type == type && ((Instance)instance).level > newLevel);
    }

    private void revoke(ServerPlayerEntity player, Predicate<Instance> instancePredicate) {
        PlayerAdvancements advancements = player.func_192039_O();
        ((PlayerAdvancementsAccessor)advancements).getAdvancements().entrySet().stream().filter(entry -> !((AdvancementProgress)entry.getValue()).func_192105_a()).forEach(advancementProgressEntry -> {
            if (((Advancement)advancementProgressEntry.getKey()).func_192073_f().values().stream().anyMatch(pair -> {
                ICriterionInstance trigger = pair.func_192143_a();
                return trigger != null && trigger.func_192244_a().equals((Object)ID) && instancePredicate.test((Instance)trigger);
            })) {
                ((AdvancementProgress)advancementProgressEntry.getValue()).func_192102_e().forEach(a -> advancements.func_192744_b((Advancement)advancementProgressEntry.getKey(), a));
            }
        });
    }

    @Nonnull
    protected Instance createInstance(JsonObject json, @Nonnull EntityPredicate.AndPredicate entityPredicate, @Nonnull ConditionArrayParser conditionsParser) {
        String idStr;
        Type type;
        IPlayableFaction faction = null;
        Type type2 = type = json.has("type") ? Type.valueOf(json.get("type").getAsString()) : Type.LEVEL;
        if (json.has("faction") && !"null".equals(idStr = json.get("faction").getAsString())) {
            ResourceLocation id = new ResourceLocation(json.get("faction").getAsString());
            IFaction faction1 = VampirismAPI.factionRegistry().getFactionByID(id);
            if (!(faction1 instanceof IPlayableFaction)) {
                LOGGER.warn("Given faction name does not exist or is not a playable faction: {}", (Object)id);
            } else {
                faction = (IPlayableFaction)faction1;
            }
        }
        int level = json.has("level") ? json.get("level").getAsInt() : 1;
        return new Instance(type, faction, level);
    }

    static class Instance
    extends CriterionInstance {
        @Nonnull
        private final Type type;
        @Nullable
        private final IPlayableFaction<?> faction;
        private final int level;

        Instance(@Nonnull Type type, @Nullable IPlayableFaction<?> faction, int level) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.type = type;
            this.faction = faction;
            this.level = level;
        }

        @Nonnull
        public JsonObject func_230240_a_(@Nonnull ConditionArraySerializer serializer) {
            JsonObject json = super.func_230240_a_(serializer);
            json.addProperty("type", this.type.name());
            json.addProperty("faction", this.faction == null ? "null" : this.faction.getID().toString());
            json.addProperty("level", (Number)this.level);
            return json;
        }

        public boolean test(IPlayableFaction<?> faction, int level, int lordLevel) {
            if (faction == null && this.faction == null || Objects.equals(this.faction, faction)) {
                if (this.type == Type.LEVEL) {
                    return level >= this.level;
                }
                if (this.type == Type.LORD) {
                    return lordLevel >= this.level;
                }
            }
            return false;
        }
    }

    public static enum Type {
        LEVEL,
        LORD;

    }
}

