/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import de.teamlapen.vampirism.api.ClientHelper;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionManager;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.player.actions.IActionManager;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVisionRegistry;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.api.world.IGarlicChunkHandler;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import de.teamlapen.vampirism.api.world.IWorldGenManager;
import java.io.Serializable;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class VampirismAPI {
    private static boolean INIT;
    @Deprecated
    private static final IGarlicChunkHandler dummyGarlicChunkHandler;
    @CapabilityInject(value=IExtendedCreatureVampirism.class)
    private static Capability<IExtendedCreatureVampirism> CAP_CREATURE;
    @CapabilityInject(value=IFactionPlayerHandler.class)
    private static Capability<IFactionPlayerHandler> CAP_FACTION_HANDLER_PLAYER;
    @CapabilityInject(value=IVampirismWorld.class)
    private static Capability<IVampirismWorld> CAP_WORLD;
    private static IFactionRegistry factionRegistry;
    private static ISundamageRegistry sundamageRegistry;
    private static IVampirismEntityRegistry entityRegistry;
    private static IVampireVisionRegistry vampireVisionRegistry;
    private static ISkillManager skillManager;
    private static IActionManager actionManager;
    private static IEntityActionManager entityActionManager;
    private static IWorldGenManager worldGenRegistry;
    private static IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry;

    public static ISkillManager skillManager() {
        return skillManager;
    }

    public static IActionManager actionManager() {
        return actionManager;
    }

    public static IEntityActionManager entityActionManager() {
        return entityActionManager;
    }

    public static IVampireVisionRegistry vampireVisionRegistry() {
        return vampireVisionRegistry;
    }

    public static IFactionRegistry factionRegistry() {
        return factionRegistry;
    }

    public static ISundamageRegistry sundamageRegistry() {
        return sundamageRegistry;
    }

    public static IVampirismEntityRegistry entityRegistry() {
        return entityRegistry;
    }

    public static IWorldGenManager worldGenRegistry() {
        return worldGenRegistry;
    }

    public static IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry() {
        return extendedBrewingRecipeRegistry;
    }

    public static void setUpRegistries(IFactionRegistry factionRegistryIn, ISundamageRegistry sundamageRegistryIn, IVampirismEntityRegistry entityRegistryIn, IActionManager actionManagerIn, ISkillManager skillManagerIn, IVampireVisionRegistry vampireVisionRegistryIn, IEntityActionManager entityActionManagerIn, IWorldGenManager worldGenRegistryIn, IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistryIn) {
        if (INIT) {
            throw new IllegalStateException("Vampirism API can only be setup once");
        }
        factionRegistry = factionRegistryIn;
        sundamageRegistry = sundamageRegistryIn;
        entityRegistry = entityRegistryIn;
        actionManager = actionManagerIn;
        skillManager = skillManagerIn;
        vampireVisionRegistry = vampireVisionRegistryIn;
        entityActionManager = entityActionManagerIn;
        worldGenRegistry = worldGenRegistryIn;
        extendedBrewingRecipeRegistry = extendedBrewingRecipeRegistryIn;
        INIT = true;
    }

    @Deprecated
    public static void onSetupComplete() {
    }

    public static LazyOptional<IFactionPlayerHandler> getFactionPlayerHandler(PlayerEntity player) {
        return player.getCapability(CAP_FACTION_HANDLER_PLAYER, null);
    }

    public static LazyOptional<IExtendedCreatureVampirism> getExtendedCreatureVampirism(CreatureEntity creature) {
        return creature.getCapability(CAP_CREATURE, null);
    }

    @Deprecated
    @Nonnull
    public static IGarlicChunkHandler getGarlicChunkHandler(RegistryKey<World> world) {
        World w = (World)DistExecutor.safeRunForDist(() -> (DistExecutor.SafeSupplier & Serializable)() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                return server.func_71218_a(world);
            }
            return ClientHelper.getAndCheckWorld(world);
        }, () -> (DistExecutor.SafeSupplier & Serializable)() -> ServerLifecycleHooks.getCurrentServer().func_71218_a(world));
        if (w != null) {
            return w.getCapability(CAP_WORLD).map(iw -> iw).orElse(dummyGarlicChunkHandler);
        }
        return dummyGarlicChunkHandler;
    }

    public static LazyOptional<IVampirismWorld> getVampirismWorld(World w) {
        return w.getCapability(CAP_WORLD);
    }

    static {
        dummyGarlicChunkHandler = new IGarlicChunkHandler(){

            @Override
            public void clear() {
            }

            @Override
            @Nonnull
            public EnumStrength getStrengthAtChunk(ChunkPos pos) {
                return EnumStrength.NONE;
            }

            @Override
            public int registerGarlicBlock(EnumStrength strength, ChunkPos ... pos) {
                return 0;
            }

            @Override
            public void removeGarlicBlock(int id) {
            }
        };
        CAP_CREATURE = null;
        CAP_FACTION_HANDLER_PLAYER = null;
        CAP_WORLD = null;
    }
}

