/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.convertible;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public interface ICurableConvertedCreature<T extends CreatureEntity>
extends IConvertedCreature<T> {
    default public T createCuredEntity(CreatureEntity entity, EntityType<T> newType) {
        CreatureEntity newEntity = (CreatureEntity)newType.func_200721_a(entity.field_70170_p);
        newEntity.func_70020_e(entity.func_189511_e(new CompoundNBT()));
        newEntity.field_70761_aq = entity.field_70761_aq;
        newEntity.field_70759_as = entity.field_70759_as;
        newEntity.func_184221_a(UUID.randomUUID());
        return (T)newEntity;
    }

    default public T cureEntity(ServerWorld world, CreatureEntity entity, EntityType<T> newType) {
        T newEntity = this.createCuredEntity(entity, newType);
        entity.func_70106_y();
        entity.field_70170_p.func_217376_c(newEntity);
        newEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
        if (!entity.func_174814_R()) {
            world.func_217378_a(null, 1027, entity.func_233580_cy_(), 0);
        }
        VampirismAPI.getExtendedCreatureVampirism(newEntity).ifPresent(creature -> creature.setBlood(1));
        ForgeEventFactory.onLivingConvert((LivingEntity)entity, newEntity);
        return newEntity;
    }

    public DataParameter<Boolean> getConvertingDataParam();

    default public boolean handleSound(byte id, CreatureEntity entity) {
        if (id == 16) {
            if (!entity.func_174814_R()) {
                entity.field_70170_p.func_184134_a(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_(), SoundEvents.field_187942_hp, entity.func_184176_by(), 1.0f + entity.func_70681_au().nextFloat(), entity.func_70681_au().nextFloat() * 0.7f + 0.3f, false);
            }
            return true;
        }
        return false;
    }

    default public ActionResultType interactWithCureItem(PlayerEntity player, ItemStack stack, CreatureEntity entity) {
        if (!entity.func_70644_a(Effects.field_76437_t)) {
            return ActionResultType.CONSUME;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (!entity.field_70170_p.field_72995_K) {
            this.startConverting(player.func_110124_au(), entity.func_70681_au().nextInt(2400) + 2400, entity);
        }
        return ActionResultType.SUCCESS;
    }

    default public boolean isConverting(CreatureEntity entity) {
        return (Boolean)entity.func_184212_Q().func_187225_a(this.getConvertingDataParam());
    }

    default public void registerConvertingData(@Nonnull CreatureEntity entity) {
        entity.func_184212_Q().func_187214_a(this.getConvertingDataParam(), (Object)false);
    }

    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @Nonnull CreatureEntity entity) {
        entity.func_184212_Q().func_187227_b(this.getConvertingDataParam(), (Object)true);
        entity.func_195063_d(Effects.field_76437_t);
        entity.field_70170_p.func_72960_a((Entity)entity, (byte)16);
    }
}

