/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DefaultSkill<T extends IFactionPlayer>
extends ForgeRegistryEntry<ISkill>
implements ISkill {
    private final Map<Attribute, LazyOptional<AttributeModifier>> attributeModifierMap = new HashMap<Attribute, LazyOptional<AttributeModifier>>();
    private int renderRow;
    private int renderColumn;
    private ITextComponent name;

    @Override
    public ITextComponent getName() {
        return this.name == null ? (this.name = new TranslationTextComponent(this.getTranslationKey())) : this.name;
    }

    public DefaultSkill<T> setName(ITextComponent name) {
        this.name = name;
        return this;
    }

    @Override
    public int getRenderColumn() {
        return this.renderColumn;
    }

    @Override
    public int getRenderRow() {
        return this.renderRow;
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return "skill." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a();
    }

    @Override
    public final void onDisable(IFactionPlayer player) {
        this.removeAttributesModifiersFromEntity(player.getRepresentingPlayer());
        player.getActionHandler().relockActions(this.getActions());
        if (!this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
        }
        this.onDisabled(player);
    }

    @Override
    public final void onEnable(IFactionPlayer player) {
        this.applyAttributesModifiersToEntity(player.getRepresentingPlayer());
        player.getActionHandler().unlockActions(this.getActions());
        if (!this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
        }
        this.onEnabled(player);
    }

    public DefaultSkill<T> registerAttributeModifier(Attribute attribute, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), amount, operation);
        this.attributeModifierMap.put(attribute, (LazyOptional<AttributeModifier>)LazyOptional.of(() -> attributemodifier));
        return this;
    }

    public DefaultSkill<T> registerAttributeModifier(Attribute attribute, String uuid, Supplier<Double> amountSupplier, AttributeModifier.Operation operation) {
        this.attributeModifierMap.put(attribute, (LazyOptional<AttributeModifier>)LazyOptional.of(() -> new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), ((Double)amountSupplier.get()).doubleValue(), operation)));
        return this;
    }

    @Override
    public void setRenderPos(int row, int column) {
        this.renderRow = row;
        this.renderColumn = column;
    }

    public String toString() {
        return this.getRegistryName() + "(" + this.getClass().getSimpleName() + ")";
    }

    protected void getActions(Collection<IAction> list) {
    }

    protected void onDisabled(T player) {
    }

    protected void onEnabled(T player) {
    }

    private void applyAttributesModifiersToEntity(PlayerEntity player) {
        for (Map.Entry<Attribute, LazyOptional<AttributeModifier>> entry : this.attributeModifierMap.entrySet()) {
            ModifiableAttributeInstance iattributeinstance = player.func_110148_a(entry.getKey());
            if (iattributeinstance == null) continue;
            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue().orElseThrow(IllegalStateException::new);
            iattributeinstance.func_111124_b(attributemodifier);
            iattributeinstance.func_233769_c_(new AttributeModifier(attributemodifier.func_111167_a(), this.getRegistryName().toString(), attributemodifier.func_111164_d(), attributemodifier.func_220375_c()));
        }
    }

    private Collection<IAction> getActions() {
        ArrayList<IAction> collection = new ArrayList<IAction>();
        this.getActions(collection);
        collection.forEach(iAction -> {
            if (!iAction.getFaction().equals(this.getFaction())) {
                throw new IllegalArgumentException("Can't register action of faction " + iAction.getFaction() + " for skill of faction" + this.getFaction());
            }
        });
        return collection;
    }

    private void removeAttributesModifiersFromEntity(PlayerEntity player) {
        for (Map.Entry<Attribute, LazyOptional<AttributeModifier>> entry : this.attributeModifierMap.entrySet()) {
            ModifiableAttributeInstance iattributeinstance = player.func_110148_a(entry.getKey());
            if (iattributeinstance == null) continue;
            iattributeinstance.func_111124_b((AttributeModifier)entry.getValue().orElseThrow(IllegalStateException::new));
        }
    }
}

