/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public enum SkillType implements ISkillType
{
    LEVEL(new ResourceLocation("vampirism", "level"), "", faction -> true, faction -> true),
    LORD(new ResourceLocation("vampirism", "lord"), "_lord", IPlayableFaction::hasLordSkills, handler -> handler.getLordLevel() > 0);

    public final ResourceLocation id;
    public final String nameSuffix;
    public final Predicate<IPlayableFaction> isForFaction;
    public final Predicate<IFactionPlayerHandler> isUnlocked;

    private SkillType(ResourceLocation id, String nameSuffix, Predicate<IPlayableFaction> isForFaction, Predicate<IFactionPlayerHandler> isUnlocked) {
        this.id = id;
        this.nameSuffix = nameSuffix;
        this.isForFaction = isForFaction;
        this.isUnlocked = isUnlocked;
    }

    @Override
    public ResourceLocation createIdForFaction(@Nonnull ResourceLocation id) {
        return new ResourceLocation(id.func_110624_b(), id.func_110623_a() + this.nameSuffix);
    }

    @Override
    public boolean isForFaction(@Nonnull IPlayableFaction faction) {
        return this.isForFaction.test(faction);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.id;
    }

    @Override
    public boolean isUnlocked(IFactionPlayerHandler handler) {
        return this.isUnlocked.test(handler);
    }
}

