/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.general;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.VReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class BloodConversionRegistry {
    @Nonnull
    private static final Map<ResourceLocation, Float> items = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Float> fluids = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Float> entities = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Float> items_calculated = Maps.newHashMap();
    @Nonnull
    private static final Set<ResourceLocation> items_blacklist = Sets.newHashSet();

    @Deprecated
    public static void applyNewFluidResources(Map<ResourceLocation, Integer> values, int divider) {
        BloodConversionRegistry.applyNewFluidResources(values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf((float)((Integer)e.getValue()).intValue() / (float)divider))));
    }

    @Deprecated
    public static void applyNewItemResources(Map<ResourceLocation, Integer> values, int multiplier) {
        BloodConversionRegistry.applyNewItemResources(values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf((float)((Integer)e.getValue()).intValue() * (float)multiplier))));
    }

    @Deprecated
    public static void applyNewItemCalculated(Map<ResourceLocation, Integer> values) {
        items_calculated.putAll(values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf((float)((Integer)e.getValue()).intValue() * 100.0f))));
    }

    @Deprecated
    public static Map<ResourceLocation, Integer> getItemValues() {
        return items.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)(((Float)e.getValue()).floatValue() / 100.0f)));
    }

    @Deprecated
    public static Map<ResourceLocation, Integer> getFluidValues() {
        return fluids.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)(((Float)e.getValue()).floatValue() * 100.0f)));
    }

    @Deprecated
    public static Map<ResourceLocation, Integer> getItemValuesCalculated() {
        return items_calculated.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)(((Float)e.getValue()).floatValue() / 100.0f)));
    }

    public static void applyNewFluidResources(Map<ResourceLocation, Float> values) {
        fluids.clear();
        fluids.putAll(values);
    }

    public static void applyNewEntitiesResources(Map<ResourceLocation, Float> values) {
        entities.clear();
        entities.putAll(values);
    }

    public static void applyNewItemResources(Map<ResourceLocation, Float> values) {
        items.clear();
        for (Map.Entry<ResourceLocation, Float> value : values.entrySet()) {
            if (value.getValue().floatValue() != 0.0f) {
                items.put(value.getKey(), value.getValue());
                continue;
            }
            items_blacklist.add(value.getKey());
        }
    }

    public static Map<ResourceLocation, Float> getItemConversions() {
        return Collections.unmodifiableMap(items);
    }

    public static Map<ResourceLocation, Float> getEntityConversions() {
        return Collections.unmodifiableMap(entities);
    }

    public static Map<ResourceLocation, Float> getFluidConversions() {
        return Collections.unmodifiableMap(fluids);
    }

    public static Map<ResourceLocation, Float> getItemConversionCalculated() {
        return Collections.unmodifiableMap(items_calculated);
    }

    @Deprecated
    public static int getFluidDivider() {
        return 100;
    }

    @Deprecated
    public static int getItemMultiplier() {
        return 100;
    }

    public static int getImpureBloodValue(@Nonnull Item item) {
        if (items.containsKey(item.getRegistryName()) || items_calculated.containsKey(item.getRegistryName())) {
            return (items.containsKey(item.getRegistryName()) ? items.get(item.getRegistryName()) : items_calculated.get(item.getRegistryName())).intValue();
        }
        return 0;
    }

    public static boolean canBeConverted(@Nonnull Item item) {
        int value;
        if (items.containsKey(item.getRegistryName()) || items_calculated.containsKey(item.getRegistryName())) {
            return true;
        }
        if (items_blacklist.contains(item.getRegistryName())) {
            return false;
        }
        if (item.func_219971_r() && item.func_219967_s().func_221467_c() && (value = MathHelper.func_76125_a((int)(item.getRegistryName() != null && item.getRegistryName().func_110623_a().contains("cooked") ? 0 : item.func_219967_s().func_221466_a() / 2), (int)0, (int)5)) > 0) {
            items_calculated.put(item.getRegistryName(), Float.valueOf(value * 100));
            return true;
        }
        items_blacklist.add(item.getRegistryName());
        return false;
    }

    public static float getBloodValue(@Nonnull FluidStack fluid) {
        if (fluids.containsKey(fluid.getFluid().getRegistryName())) {
            return fluids.get(fluid.getFluid().getRegistryName()).floatValue();
        }
        return 0.0f;
    }

    public static boolean existsBloodValue(@Nonnull Fluid fluid) {
        return fluids.containsKey(fluid.getRegistryName());
    }

    public static FluidStack getBloodFromFluid(@Nonnull FluidStack fluid) {
        if (fluid.getFluid().func_207187_a((Fluid)VReference.blood_fluid_supplier.get())) {
            return fluid;
        }
        return new FluidStack((Fluid)VReference.blood_fluid_supplier.get(), (int)(BloodConversionRegistry.getBloodValue(fluid) * (float)fluid.getAmount()));
    }
}

