/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.tileentity.CoffinTileEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CoffinBlock
extends VampirismBlockContainer {
    public static final Map<DyeColor, CoffinBlock> COFFIN_BLOCKS = new HashMap<DyeColor, CoffinBlock>();
    public static final EnumProperty<CoffinPart> PART = EnumProperty.func_177709_a((String)"part", CoffinPart.class);
    public static final BooleanProperty CLOSED = BooleanProperty.func_177716_a((String)"closed");
    public static final BooleanProperty VERTICAL = BooleanProperty.func_177716_a((String)"vertical");
    private static ShapeTable shapes = new ShapeTable();
    private static final Map<PlayerEntity.SleepResult, ITextComponent> sleepResults = ImmutableMap.of((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW, (Object)new TranslationTextComponent("text.vampirism.coffin.no_sleep"), (Object)PlayerEntity.SleepResult.TOO_FAR_AWAY, (Object)new TranslationTextComponent("text.vampirism.coffin.too_far_away"), (Object)PlayerEntity.SleepResult.OBSTRUCTED, (Object)new TranslationTextComponent("text.vampirism.coffin.obstructed"));
    private final DyeColor color;

    public static boolean isOccupied(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof CoffinBlock && (Boolean)state.func_177229_b((Property)BedBlock.field_176471_b) != false;
    }

    public static boolean isClosed(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof CoffinBlock && (Boolean)state.func_177229_b((Property)CLOSED) != false;
    }

    public static boolean isHead(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof CoffinBlock && state.func_177229_b(PART) == CoffinPart.HEAD;
    }

    private static Direction getDirectionToOther(CoffinPart type, Direction facing) {
        return type == CoffinPart.FOOT ? facing : facing.func_176734_d();
    }

    public CoffinBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.2f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.FALSE)).func_206870_a(PART, (Comparable)((Object)CoffinPart.FOOT))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)VERTICAL, (Comparable)Boolean.valueOf(false)));
        this.color = color;
        COFFIN_BLOCKS.put(color, this);
    }

    public Direction getBedDirection(BlockState state, IWorldReader world, BlockPos pos) {
        return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    @Nonnull
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing = context.func_195992_f();
        boolean vertical = context.func_196000_l().func_176740_k() != Direction.Axis.Y;
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(vertical ? Direction.UP : enumfacing);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)enumfacing)).func_206870_a((Property)VERTICAL, (Comparable)Boolean.valueOf(vertical)) : null;
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return false;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shapes.getShape((CoffinPart)((Object)state.func_177229_b(PART)), (Boolean)state.func_177229_b((Property)CLOSED), (Boolean)state.func_177229_b((Property)VERTICAL), (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J));
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, Entity player) {
        return (Boolean)state.func_177229_b((Property)CLOSED) == false || (Boolean)state.func_177229_b((Property)BedBlock.field_176471_b) != false;
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader worldIn) {
        return new CoffinTileEntity(this.color);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        CoffinPart part;
        if (!worldIn.field_72995_K && player.func_184812_l_() && (part = (CoffinPart)((Object)state.func_177229_b(PART))) == CoffinPart.FOOT && (blockstate = worldIn.func_180495_p(blockpos = this.getOtherPos(pos, state))).func_177230_c() == this && blockstate.func_177229_b(PART) == CoffinPart.HEAD) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.func_180633_a(worldIn, pos, state, entity, itemStack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = this.getOtherPos(pos, state);
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)CoffinPart.HEAD)), 3);
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == CoffinBlock.getDirectionToOther((CoffinPart)((Object)stateIn.func_177229_b(PART)), (Boolean)stateIn.func_177229_b((Property)VERTICAL) != false ? Direction.UP : (Direction)stateIn.func_177229_b((Property)BlockStateProperties.field_208157_J))) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((Property)BedBlock.field_176471_b, facingState.func_177229_b((Property)BedBlock.field_176471_b)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(PART) != CoffinPart.HEAD && !(state = worldIn.func_180495_p(pos = this.getOtherPos(pos, state))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (player.func_225608_bj_() && !((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)CLOSED) == false)), 3);
            BlockPos otherPos = this.getOtherPos(pos, state);
            worldIn.func_180501_a(otherPos, (BlockState)worldIn.func_180495_p(otherPos).func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)CLOSED) == false)), 3);
            return ActionResultType.CONSUME;
        }
        if (VampirismPlayerAttributes.get((PlayerEntity)player).vampireLevel == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.coffin.cant_use"), true);
            return ActionResultType.CONSUME;
        }
        if (((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.coffin.occupied"), true);
            return ActionResultType.CONSUME;
        }
        if (((Boolean)state.func_177229_b((Property)CLOSED)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.coffin.closed"), true);
            return ActionResultType.CONSUME;
        }
        if (!BedBlock.func_235330_a_((World)worldIn)) {
            worldIn.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a((Boolean)state.func_177229_b((Property)VERTICAL) != false ? Direction.DOWN : ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
            if (worldIn.func_180495_p(blockpos).func_203425_a((Block)this)) {
                worldIn.func_217377_a(blockpos, false);
            }
            worldIn.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.CONSUME;
        }
        if (((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.coffin.occupied"), true);
            return ActionResultType.CONSUME;
        }
        BlockPos finalPos = pos;
        BlockState finalState = state;
        player.func_213819_a(pos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.func_146105_b(sleepResults.getOrDefault(sleepResult1, sleepResult1.func_221259_a()), true);
            }
        }).ifRight(u -> CoffinBlock.setCoffinSleepPosition(player, finalPos, finalState));
        return ActionResultType.CONSUME;
    }

    public static void setCoffinSleepPosition(PlayerEntity player, BlockPos blockPos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)VERTICAL)).booleanValue()) {
            double z;
            double x;
            player.func_213301_b(Pose.STANDING);
            switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                case NORTH: {
                    x = 0.5;
                    z = 0.3;
                    player.field_70759_as = 0.0f;
                    player.field_70761_aq = 0.0f;
                    break;
                }
                case EAST: {
                    x = 0.7;
                    z = 0.5;
                    player.field_70759_as = 90.0f;
                    player.field_70761_aq = 90.0f;
                    break;
                }
                case SOUTH: {
                    x = 0.5;
                    z = 0.7;
                    player.field_70759_as = 180.0f;
                    player.field_70761_aq = 180.0f;
                    break;
                }
                case WEST: {
                    x = 0.3;
                    z = 0.5;
                    player.field_70759_as = 270.0f;
                    player.field_70761_aq = 270.0f;
                    break;
                }
                default: {
                    return;
                }
            }
            player.func_70107_b((double)blockPos.func_177958_n() + x, (double)(blockPos.func_177956_o() - 1), (double)blockPos.func_177952_p() + z);
            player.func_174826_a(new AxisAlignedBB((double)blockPos.func_177958_n() + x - 0.2, (double)blockPos.func_177956_o() - 0.8, (double)blockPos.func_177952_p() + z - 0.2, (double)blockPos.func_177958_n() + x + 0.2, (double)blockPos.func_177956_o() + 0.4, (double)blockPos.func_177952_p() + z + 0.2));
        } else {
            player.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.2, (double)blockPos.func_177952_p() + 0.5);
            player.func_174826_a(player.field_213325_aI.func_242285_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.2, (double)blockPos.func_177952_p() + 0.5).func_186664_h(0.3));
        }
    }

    public BlockPos getOtherPos(BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)VERTICAL)).booleanValue()) {
            if (state.func_177229_b(PART) == CoffinPart.FOOT) {
                return pos.func_177984_a();
            }
            return pos.func_177977_b();
        }
        if (state.func_177229_b(PART) == CoffinPart.FOOT) {
            return pos.func_177972_a((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D));
        }
        return pos.func_177972_a(((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d());
    }

    public void setBedOccupied(BlockState state, World world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        super.setBedOccupied(state, world, pos, sleeper, occupied);
        world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)CLOSED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, BedBlock.field_176471_b, PART, CLOSED, VERTICAL});
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static class ShapeTable {
        private final VoxelShape[][][][] shapes = this.buildShapes();

        public VoxelShape getShape(CoffinPart part, boolean closed, boolean vertical, Direction facing) {
            return this.shapes[part.ordinal()][closed ? 1 : 0][vertical ? 1 : 0][facing.func_176736_b()];
        }

        private VoxelShape[][][][] buildShapes() {
            VoxelShape shape = VoxelShapes.func_197880_a();
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.0625, (double)0.046875, (double)0.96875, (double)0.1875, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.875, (double)0.1875, (double)1.375, (double)0.9375, (double)0.375, (double)1.875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.875, (double)0.1875, (double)0.75, (double)0.9375, (double)0.375, (double)1.25), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.875, (double)0.1875, (double)0.125, (double)0.9375, (double)0.375, (double)0.625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.25, (double)0.1875, (double)1.875, (double)0.75, (double)0.375, (double)1.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.1875, (double)0.125, (double)0.125, (double)0.375, (double)0.625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.1875, (double)0.75, (double)0.125, (double)0.375, (double)1.25), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.1875, (double)1.375, (double)0.125, (double)0.375, (double)1.875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.25, (double)0.1875, (double)0.0625, (double)0.75, (double)0.375, (double)0.125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.0625, (double)0.046875, (double)0.09375, (double)0.1875, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.0625, (double)1.921875, (double)0.90625, (double)0.1875, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.0625, (double)0.046875, (double)0.90625, (double)0.1875, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.1875, (double)1.875, (double)0.96875, (double)0.375, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.1875, (double)1.25, (double)0.96875, (double)0.375, (double)1.375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.1875, (double)0.625, (double)0.96875, (double)0.375, (double)0.75), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.1875, (double)0.046875, (double)0.96875, (double)0.375, (double)0.125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.1875, (double)0.046875, (double)0.09375, (double)0.375, (double)0.125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.1875, (double)0.625, (double)0.09375, (double)0.375, (double)0.75), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.1875, (double)1.25, (double)0.09375, (double)0.375, (double)1.375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.1875, (double)1.875, (double)0.09375, (double)0.375, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.1875, (double)1.921875, (double)0.25, (double)0.375, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.75, (double)0.1875, (double)1.921875, (double)0.90625, (double)0.375, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.75, (double)0.1875, (double)0.046875, (double)0.90625, (double)0.375, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.1875, (double)0.046875, (double)0.25, (double)0.375, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.375, (double)0.046875, (double)0.90625, (double)0.5, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.375, (double)0.046875, (double)0.09375, (double)0.5, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.375, (double)1.921875, (double)0.90625, (double)0.5, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.375, (double)0.046875, (double)0.96875, (double)0.5, (double)1.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.5, (double)0.0, (double)1.0, (double)0.5625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.5, (double)0.0, (double)0.09375, (double)0.5625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.5, (double)1.921875, (double)0.90625, (double)0.5625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.5, (double)0.0, (double)0.90625, (double)0.5625, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.0625, (double)0.09375, (double)0.140625, (double)0.546875, (double)1.921875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.859375, (double)0.0625, (double)0.09375, (double)0.90625, (double)0.546875, (double)1.921875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.140625, (double)0.0625, (double)1.859375, (double)0.859375, (double)0.546875, (double)1.921875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.140625, (double)0.0625, (double)0.09375, (double)0.859375, (double)0.546875, (double)0.15625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.3125, (double)0.5), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.203125, (double)0.203125, (double)0.4375, (double)0.796875, (double)0.34375, (double)0.5625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.203125, (double)0.203125, (double)0.171875, (double)0.796875, (double)0.328125, (double)0.296875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.9375, (double)0.09375, (double)0.25, (double)1.0, (double)0.15625, (double)0.5), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.9375, (double)0.09375, (double)0.875, (double)1.0, (double)0.15625, (double)1.125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.9375, (double)0.09375, (double)1.5, (double)1.0, (double)0.15625, (double)1.75), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.09375, (double)1.5, (double)0.0625, (double)0.15625, (double)1.75), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.09375, (double)0.875, (double)0.0625, (double)0.15625, (double)1.125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.09375, (double)0.25, (double)0.0625, (double)0.15625, (double)0.5), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            VoxelShape lidShape = VoxelShapes.func_197880_a();
            lidShape = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.5625, (double)0.0, (double)0.09375, (double)0.625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            lidShape = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.5625, (double)0.0, (double)0.90625, (double)0.625, (double)0.078125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            lidShape = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.5625, (double)0.0, (double)1.0, (double)0.625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            lidShape = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.5625, (double)1.90625, (double)0.90625, (double)0.625, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            lidShape = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.625, (double)0.0625, (double)0.90625, (double)0.6875, (double)1.921875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            VoxelShape head = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223238_i_);
            VoxelShape foot = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223238_i_).func_197751_a(0.0, 0.0, -1.0);
            VoxelShape lidHead = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223238_i_);
            VoxelShape lidFoot = VoxelShapes.func_197878_a((VoxelShape)lidShape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223238_i_).func_197751_a(0.0, 0.0, -1.0);
            VoxelShape[][][][] shapes = new VoxelShape[2][][][];
            shapes[CoffinPart.HEAD.ordinal()] = this.buildShapePart(head, lidHead);
            shapes[CoffinPart.FOOT.ordinal()] = this.buildShapePart(foot, lidFoot);
            return shapes;
        }

        private VoxelShape[][][] buildShapePart(VoxelShape shape, VoxelShape shapeLid) {
            VoxelShape[][][] shapes = new VoxelShape[][][]{this.buildShapeClosed(shape, shapeLid, false), this.buildShapeClosed(shape, shapeLid, true)};
            return shapes;
        }

        private VoxelShape[][] buildShapeClosed(VoxelShape shape, VoxelShape shapeLid, boolean closed) {
            if (closed) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)shapeLid);
            }
            VoxelShape[][] shapes = new VoxelShape[][]{this.buildShapeVertical(shape, false), this.buildShapeVertical(shape, true)};
            return shapes;
        }

        private VoxelShape[] buildShapeVertical(VoxelShape shape, boolean vertical) {
            if (vertical) {
                shape = UtilLib.rollShape(shape, Direction.NORTH);
            }
            VoxelShape[] shapes = new VoxelShape[4];
            VoxelShape finalShape = shape;
            Direction.Plane.HORIZONTAL.func_239636_a_().forEach(dir -> {
                shapes[dir.func_176736_b()] = this.buildShapeDirectional(finalShape, (Direction)dir);
            });
            return shapes;
        }

        private VoxelShape buildShapeDirectional(VoxelShape shape, Direction direction) {
            switch (direction) {
                case NORTH: {
                    return shape;
                }
                case EAST: {
                    return UtilLib.rotateShape(shape, UtilLib.RotationAmount.NINETY);
                }
                case SOUTH: {
                    return UtilLib.rotateShape(shape, UtilLib.RotationAmount.HUNDRED_EIGHTY);
                }
                case WEST: {
                    return UtilLib.rotateShape(shape, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
                }
            }
            throw new IllegalArgumentException("Wrong direction argument");
        }
    }

    public static enum CoffinPart implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private CoffinPart(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

