/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CursedBarkBlock
extends Block {
    private static final VoxelShape shape = VoxelShapes.func_197880_a();
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final DirectionProperty FACING2 = DirectionProperty.func_196962_a((String)"facing_2", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;

    public CursedBarkBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151582_l, (MaterialColor)MaterialColor.field_151660_b).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_235601_w_));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FACING2, (Comparable)Direction.NORTH)).func_206870_a(AXIS, (Comparable)Direction.Axis.Y));
    }

    public void func_196262_a(@Nonnull BlockState state, @Nonnull World level, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (Helper.isVampire(entity) || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a) {
            return;
        }
        Direction mainDirection = (Direction)state.func_177229_b((Property)FACING);
        Direction secondaryDirection = (Direction)state.func_177229_b((Property)FACING2);
        BlockPos targetPos = pos.func_177972_a(mainDirection);
        if (mainDirection != secondaryDirection) {
            targetPos = targetPos.func_177972_a(secondaryDirection);
        }
        Vector3d thrust = new Vector3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()).func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72432_b().func_186678_a(0.04);
        if (!entity.func_233570_aj_()) {
            thrust = thrust.func_186678_a(0.3);
        }
        entity.func_213317_d(entity.func_213322_ci().func_178787_e(thrust));
        if (!level.field_72995_K) {
            if (entity instanceof PlayerEntity) {
                VampirePlayer.getOpt((PlayerEntity)entity).ifPresent(vampire -> {
                    if (vampire.getRemainingBarkTicks() == 0) {
                        vampire.removeBlood(0.02f);
                        vampire.increaseRemainingBarkTicks(40);
                    }
                });
            } else {
                ExtendedCreature.getSafe(entity).ifPresent(creature -> {
                    if (((ExtendedCreature)creature).getRemainingBarkTicks() == 0) {
                        creature.setBlood(creature.getBlood() - 1);
                        ((ExtendedCreature)creature).sync();
                        ((ExtendedCreature)creature).increaseRemainingBarkTicks(40);
                    }
                });
            }
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader blockReader, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return shape;
    }

    private boolean canAttachTo(IBlockReader blockReader, BlockPos pos, Direction direction) {
        BlockState blockstate = blockReader.func_180495_p(pos);
        return blockstate.func_224755_d(blockReader, pos, direction);
    }

    public boolean func_196260_a(BlockState state, @Nonnull IWorldReader worldReader, BlockPos blockPos) {
        Direction mainDirection = (Direction)state.func_177229_b((Property)FACING);
        Direction secondaryDirection = (Direction)state.func_177229_b((Property)FACING2);
        BlockPos pos = blockPos.func_177972_a(secondaryDirection);
        if (mainDirection != secondaryDirection) {
            pos = pos.func_177972_a(mainDirection);
        }
        return this.canAttachTo((IBlockReader)worldReader, pos, mainDirection);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState blockState, @Nonnull Direction direction, @Nonnull BlockState otherState, @Nonnull IWorld level, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        boolean facing;
        boolean bl = facing = blockState.func_177229_b((Property)FACING) == direction;
        if (!facing && blockState.func_177229_b((Property)FACING) != blockState.func_177229_b((Property)FACING2)) {
            pos = pos.func_177972_a((Direction)blockState.func_177229_b((Property)FACING));
            boolean bl2 = facing = blockState.func_177229_b((Property)FACING2) == direction;
        }
        if (facing && !blockState.func_196955_c((IWorldReader)level, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(blockState, direction, otherState, level, pos, otherPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d())).func_206870_a((Property)FACING2, (Comparable)context.func_196010_d())).func_206870_a(AXIS, (Comparable)Direction.Axis.Y);
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FACING2, AXIS});
    }
}

