/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.tileentity.GarlicBeaconTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GarlicBeaconBlock
extends VampirismBlockContainer {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.07, 0.0, 0.07, 0.93, 0.75, 0.93);
    private static final VoxelShape shape = GarlicBeaconBlock.makeShape();
    private final Type type;

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
    }

    public GarlicBeaconBlock(Type type) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_());
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (this.type == Type.WEAK || this.type == Type.IMPROVED) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_149739_a() + "." + this.type.getName()).func_240699_a_(TextFormatting.AQUA));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("block.vampirism.garlic_beacon.tooltip1").func_240699_a_(TextFormatting.GRAY));
        int c = VampirismConfig.BALANCE.hsGarlicDiffusorEnhancedDist == null ? 1 : 1 + 2 * (this.type == Type.IMPROVED ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorEnhancedDist.get() : (this.type == Type.WEAK ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorWeakDist.get() : (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorNormalDist.get()));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.vampirism.garlic_beacon.tooltip2", new Object[]{c, c}).func_240699_a_(TextFormatting.GRAY));
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn) {
        GarlicBeaconTileEntity tile = this.getTile((IBlockReader)worldIn, pos);
        if (tile != null) {
            tile.onTouched(playerIn);
        }
    }

    public String func_149739_a() {
        return "block.vampirism.garlic_beacon";
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        GarlicBeaconTileEntity tile = new GarlicBeaconTileEntity();
        tile.setType(this.type);
        int bootTime = (Integer)VampirismConfig.BALANCE.garlicDiffusorStartupTime.get() * 20;
        if (worldIn instanceof ServerWorld && ((ServerWorld)worldIn).func_217369_A().size() <= 1) {
            bootTime >>= 2;
        }
        tile.setNewBootDelay(bootTime);
        return tile;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (te instanceof GarlicBeaconTileEntity) {
            ((GarlicBeaconTileEntity)te).onTouched(player);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        GarlicBeaconTileEntity t;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && ((Item)ModItems.PURIFIED_GARLIC.get()).equals(heldItem.func_77973_b())) {
            GarlicBeaconTileEntity t2;
            if (!world.field_72995_K && (t2 = this.getTile((IBlockReader)world, pos)) != null) {
                if (t2.getFuelTime() > 0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("block.vampirism.garlic_beacon.already_fueled"), Util.field_240973_b_);
                } else {
                    t2.onFueled();
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("block.vampirism.garlic_beacon.successfully_fueled"), Util.field_240973_b_);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (world.field_72995_K && (t = this.getTile((IBlockReader)world, pos)) != null) {
            VampirismMod.proxy.displayGarlicBeaconScreen(t, (ITextComponent)this.func_235333_g_());
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    private GarlicBeaconTileEntity getTile(IBlockReader world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof GarlicBeaconTileEntity) {
            return (GarlicBeaconTileEntity)t;
        }
        return null;
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("normal", 0),
        IMPROVED("improved", 1),
        WEAK("weak", 2);

        private final String name;
        private final int id;

        private Type(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

