/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MedChairBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.func_177709_a((String)"part", EnumPart.class);
    private static final VoxelShape SHAPE_TOP = MedChairBlock.func_208617_a((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_BOTTOM = MedChairBlock.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    private final VoxelShape NORTH1;
    private final VoxelShape EAST1;
    private final VoxelShape SOUTH1;
    private final VoxelShape WEST1;
    private final VoxelShape NORTH2;
    private final VoxelShape EAST2;
    private final VoxelShape SOUTH2;
    private final VoxelShape WEST2;

    public MedChairBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)EnumPart.BOTTOM)));
        this.NORTH1 = SHAPE_BOTTOM;
        this.EAST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.NINETY);
        this.SOUTH1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.NORTH2 = SHAPE_TOP;
        this.EAST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.NINETY);
        this.SOUTH2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (player.func_70089_S()) {
            ItemStack stack = player.func_184586_b(hand);
            if (this.handleInjections(player, world, stack)) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(stack);
                }
            }
        } else if (world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.need_item_to_use", new Object[]{new TranslationTextComponent(new ItemStack((IItemProvider)ModItems.INJECTION_GARLIC.get()).func_77977_a())}), true);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean handleGarlicInjection(@Nonnull PlayerEntity player, @Nonnull World world, @Nonnull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (handler.canJoin(VReference.HUNTER_FACTION)) {
            if (world.field_72995_K) {
                VampirismMod.proxy.renderScreenFullColor(4, 30, -1145324545);
            } else {
                handler.joinFaction(VReference.HUNTER_FACTION);
                player.func_195064_c(new EffectInstance((Effect)ModEffects.POISON.get(), 200, 1));
            }
            return true;
        }
        if (currentFaction != null && !world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.med_chair_other_faction", new Object[]{currentFaction.getName()}), Util.field_240973_b_);
        }
        return false;
    }

    private boolean handleInjections(PlayerEntity player, World world, ItemStack stack) {
        return FactionPlayerHandler.getOpt(player).map(handler -> {
            IPlayableFaction<? extends IFactionPlayer<?>> faction = handler.getCurrentFaction();
            if (stack.func_77973_b().equals(ModItems.INJECTION_GARLIC.get())) {
                return this.handleGarlicInjection(player, world, (IFactionPlayerHandler)handler, faction);
            }
            if (stack.func_77973_b().equals(ModItems.INJECTION_SANGUINARE.get())) {
                return this.handleSanguinareInjection(player, (IFactionPlayerHandler)handler, faction);
            }
            return false;
        }).orElse(false);
    }

    private boolean handleSanguinareInjection(@Nonnull PlayerEntity player, @Nonnull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (VReference.VAMPIRE_FACTION.equals(currentFaction)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.already_vampire"), false);
            return false;
        }
        if (VReference.HUNTER_FACTION.equals(currentFaction)) {
            VampirismMod.proxy.displayRevertBackScreen();
            return true;
        }
        if (currentFaction == null && handler.canJoin(VReference.VAMPIRE_FACTION)) {
            if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                SanguinareEffect.addRandom((LivingEntity)player, true);
                player.func_195064_c(new EffectInstance((Effect)ModEffects.POISON.get(), 60));
                return true;
            }
        }
        return false;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public PushReaction func_149656_h(BlockState pState) {
        return PushReaction.DESTROY;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean main = state.func_177229_b(PART) == EnumPart.BOTTOM;
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return main ? this.NORTH1 : this.NORTH2;
            }
            case EAST: {
                return main ? this.EAST1 : this.EAST2;
            }
            case SOUTH: {
                return main ? this.SOUTH1 : this.SOUTH2;
            }
            case WEST: {
                return main ? this.WEST1 : this.WEST2;
            }
        }
        return this.NORTH1;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)enumfacing.func_176734_d()) : null;
    }

    public boolean func_196266_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, PathType pType) {
        return false;
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        BlockPos blockpos;
        BlockState otherState;
        EnumPart part;
        if (!world.field_72995_K && player.func_184812_l_() && (part = (EnumPart)((Object)blockState.func_177229_b(PART))) == EnumPart.TOP && (otherState = world.func_180495_p(blockpos = blockPos.func_177972_a(this.getOtherBlockDirection(blockState)))).func_177230_c() == this && otherState.func_177229_b(PART) == EnumPart.BOTTOM) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)otherState));
        }
        super.func_176208_a(world, blockPos, blockState, player);
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        if (!world.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a(this.getOtherBlockDirection(state));
            BlockState otherState = (BlockState)state.func_206870_a(PART, (Comparable)((Object)EnumPart.TOP));
            otherState = (BlockState)otherState.func_206870_a((Property)FACING, otherState.func_177229_b((Property)FACING));
            world.func_180501_a(blockpos, otherState, 3);
            world.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)world, pos, 3);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.getOtherBlockDirection(stateIn)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? this.updateFromOther(stateIn, facingState) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PART});
    }

    protected Direction getOtherBlockDirection(BlockState blockState) {
        return blockState.func_177229_b(PART) == EnumPart.BOTTOM ? ((Direction)blockState.func_177229_b((Property)FACING)).func_176734_d() : (Direction)blockState.func_177229_b((Property)FACING);
    }

    protected BlockState updateFromOther(BlockState thisState, BlockState otherState) {
        return thisState;
    }

    public static enum EnumPart implements IStringSerializable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        public final String name;
        public final int meta;

        public static EnumPart fromMeta(int meta) {
            if (meta == 1) {
                return BOTTOM;
            }
            return TOP;
        }

        private EnumPart(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

