/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.lib.lib.client.render.RenderAreaParticleCloud;
import de.teamlapen.vampirism.client.render.entities.AdvancedHunterRenderer;
import de.teamlapen.vampirism.client.render.entities.AdvancedVampireRenderer;
import de.teamlapen.vampirism.client.render.entities.BasicHunterRenderer;
import de.teamlapen.vampirism.client.render.entities.BasicVampireRenderer;
import de.teamlapen.vampirism.client.render.entities.ConvertedChestedHorseRenderer;
import de.teamlapen.vampirism.client.render.entities.ConvertedCreatureRenderer;
import de.teamlapen.vampirism.client.render.entities.ConvertedVillagerRenderer;
import de.teamlapen.vampirism.client.render.entities.CrossbowArrowRenderer;
import de.teamlapen.vampirism.client.render.entities.DarkBloodProjectileRenderer;
import de.teamlapen.vampirism.client.render.entities.DummyRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterMinionRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterTaskMasterRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterTrainerRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterVillagerRenderer;
import de.teamlapen.vampirism.client.render.entities.SoulOrbRenderer;
import de.teamlapen.vampirism.client.render.entities.ThrowableItemRenderer;
import de.teamlapen.vampirism.client.render.entities.VampireBaronRenderer;
import de.teamlapen.vampirism.client.render.entities.VampireMinionRenderer;
import de.teamlapen.vampirism.client.render.entities.VampireTaskMasterRenderer;
import de.teamlapen.vampirism.client.render.entities.VampirismBoatRenderer;
import de.teamlapen.vampirism.client.render.layers.VampireEntityLayer;
import de.teamlapen.vampirism.core.ModEntities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.BatRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.apache.logging.log4j.LogManager;

@OnlyIn(value=Dist.CLIENT)
public class ModEntitiesRender {
    public static void registerEntityRenderer(Supplier<Minecraft> minecraftSupplier) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.BLINDING_BAT.get()), ModEntitiesRender.safeFactory(BatRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_CREATURE_IMOB.get()), ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_CREATURE.get()), ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_HORSE.get()), renderingManager -> {
            HorseRenderer renderer = new HorseRenderer(renderingManager);
            renderer.func_177094_a(new VampireEntityLayer(renderer, new ResourceLocation("vampirism", "textures/entity/vanilla/horse_overlay.png"), false));
            return renderer;
        });
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_DONKEY.get()), ModEntitiesRender.safeFactory(ConvertedChestedHorseRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_MULE.get()), ModEntitiesRender.safeFactory(ConvertedChestedHorseRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_SHEEP.get()), ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CONVERTED_COW.get()), ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.HUNTER.get()), ModEntitiesRender.safeFactory(BasicHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.HUNTER_IMOB.get()), ModEntitiesRender.safeFactory(BasicHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VAMPIRE.get()), ModEntitiesRender.safeFactory(BasicVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VAMPIRE_IMOB.get()), ModEntitiesRender.safeFactory(BasicVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.HUNTER_TRAINER.get()), e -> new HunterTrainerRenderer(e, true));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VAMPIRE_BARON.get()), ModEntitiesRender.safeFactory(VampireBaronRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.ADVANCED_HUNTER.get()), ModEntitiesRender.safeFactory(AdvancedHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.ADVANCED_HUNTER_IMOB.get()), ModEntitiesRender.safeFactory(AdvancedHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.ADVANCED_VAMPIRE.get()), ModEntitiesRender.safeFactory(AdvancedVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.ADVANCED_VAMPIRE_IMOB.get()), ModEntitiesRender.safeFactory(AdvancedVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VILLAGER_CONVERTED.get()), ModEntitiesRender.safeFactory(ConvertedVillagerRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VILLAGER_ANGRY.get()), renderManager -> new HunterVillagerRenderer(renderManager, (IReloadableResourceManager)((Minecraft)minecraftSupplier.get()).func_195551_G()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.CROSSBOW_ARROW.get()), ModEntitiesRender.safeFactory(CrossbowArrowRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.PARTICLE_CLOUD.get()), ModEntitiesRender.safeFactory(RenderAreaParticleCloud::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.THROWABLE_ITEM.get()), manager -> new ThrowableItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.DARK_BLOOD_PROJECTILE.get()), ModEntitiesRender.safeFactory(DarkBloodProjectileRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.SOUL_ORB.get()), manager -> new SoulOrbRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.HUNTER_TRAINER_DUMMY.get()), e -> new HunterTrainerRenderer(e, false));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.DUMMY_CREATURE.get()), ModEntitiesRender.safeFactory(DummyRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VAMPIRE_MINION.get()), ModEntitiesRender.safeFactory(VampireMinionRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.HUNTER_MINION.get()), ModEntitiesRender.safeFactory(HunterMinionRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.TASK_MASTER_VAMPIRE.get()), ModEntitiesRender.safeFactory(VampireTaskMasterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.TASK_MASTER_HUNTER.get()), ModEntitiesRender.safeFactory(HunterTaskMasterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.DUMMY_SIT_ENTITY.get()), ModEntitiesRender.safeFactory(DummyRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.BOAT.get()), ModEntitiesRender.safeFactory(VampirismBoatRenderer::new));
    }

    private static <T extends Entity> IRenderFactory<? super T> safeFactory(IRenderFactory<? super T> f) {
        return manager -> {
            try {
                return f.createRenderFor(manager);
            }
            catch (Exception e) {
                LogManager.getLogger().error("Failed to instantiate entity renderer", (Throwable)e);
                System.exit(0);
                throw e;
            }
        };
    }
}

