/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.client.gui.GuiPieMenu;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.SelectMinionTaskScreen;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.CActionBindingPacket;
import de.teamlapen.vampirism.network.CToggleActionPacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class SelectActionScreen
extends GuiPieMenu<IAction> {
    public static final List<IAction> ACTIONORDER = Lists.newArrayList();
    private static final IAction fakeAction = new DefaultVampireAction(){

        @Override
        public boolean activate(IVampirePlayer vampire) {
            return true;
        }

        @Override
        public int getCooldown() {
            return 0;
        }

        @Override
        public String getTranslationKey() {
            return "action.vampirism.cancel";
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    };
    public static IAction SELECTEDACTION;
    private final boolean editActions;
    private IActionHandler actionHandler;

    private static void saveActionOrder() {
        StringBuilder s = new StringBuilder();
        Iterator<IAction> iterator = ACTIONORDER.iterator();
        while (iterator.hasNext()) {
            IAction action = iterator.next();
            if (action == fakeAction) continue;
            s.append(action.getRegistryName());
            if (!iterator.hasNext()) continue;
            s.append(",");
        }
        VampirismConfig.CLIENT.actionOrder.set((Object)s.toString());
    }

    public static void loadActionOrder() {
        String[] actionOrder;
        ArrayList actions = Lists.newArrayList((Iterable)ModRegistries.ACTIONS.getValues());
        for (String s : actionOrder = ((String)VampirismConfig.CLIENT.actionOrder.get()).split(",")) {
            IAction a;
            ResourceLocation name = ResourceLocation.func_208304_a((String)s);
            if (name == null || (a = (IAction)ModRegistries.ACTIONS.getValue(name)) == null) continue;
            ACTIONORDER.add(a);
            actions.remove(a);
        }
        if (!actions.isEmpty()) {
            ACTIONORDER.addAll(actions);
            SelectActionScreen.saveActionOrder();
        }
    }

    public SelectActionScreen(Color backgroundColor, boolean edit) {
        super(backgroundColor, (ITextComponent)new TranslationTextComponent("selectAction"));
        this.editActions = edit;
    }

    public boolean func_231046_a_(int key, int scancode, int modifiers) {
        if (this.editActions && key == 256) {
            this.func_231175_as__();
            return true;
        }
        if (key == 32 && !this.editActions && FactionPlayerHandler.getOpt((PlayerEntity)this.field_230706_i_.field_71439_g).map(FactionPlayerHandler::getLordLevel).orElse(0) > 0) {
            this.field_230706_i_.func_147108_a((Screen)new SelectMinionTaskScreen());
        }
        if (this.getSelectedElement() >= 0 && this.checkBinding(binding -> binding.func_197976_a(key, scancode))) {
            return true;
        }
        return super.func_231046_a_(key, scancode, modifiers);
    }

    @Override
    public boolean func_223281_a_(int key, int scancode, int modifiers) {
        if (!this.editActions && (ModKeys.getKeyBinding(ModKeys.KEY.MINION).func_197976_a(key, scancode) || ModKeys.getKeyBinding(ModKeys.KEY.ACTION).func_197976_a(key, scancode))) {
            this.func_231175_as__();
            if (this.getSelectedElement() >= 0) {
                this.onElementSelected((IAction)this.elements.get(this.getSelectedElement()));
            }
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.getSelectedElement() >= 0) {
            if (this.editActions && mouseButton == 0) {
                if (this.elements.get(this.getSelectedElement()) != fakeAction) {
                    SELECTEDACTION = (IAction)this.elements.get(this.getSelectedElement());
                } else {
                    this.func_231175_as__();
                }
            }
            if (this.checkBinding(binding -> binding.func_197984_a(mouseButton))) {
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_231175_as__() {
        if (this.editActions) {
            SelectActionScreen.saveActionOrder();
            SELECTEDACTION = null;
        }
        super.func_231175_as__();
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.editActions) {
            if (SELECTEDACTION != null) {
                if (mouseButton == 0 && this.getSelectedElement() >= 0 && this.elements.get(this.getSelectedElement()) != fakeAction) {
                    this.switchActions(SELECTEDACTION, (IAction)this.elements.get(this.getSelectedElement()));
                    this.updateElements();
                }
                SELECTEDACTION = null;
            }
        } else {
            super.func_231048_c_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        if (this.editActions) {
            GuiUtils.drawHoveringText((MatrixStack)stack, (List)Lists.newArrayList((Object[])new IFormattableTextComponent[]{new TranslationTextComponent("gui.vampirism.action_select.action_binding"), ModKeys.getKeyBinding(ModKeys.KEY.ACTION1).func_238171_j_().func_230531_f_().func_240699_a_(TextFormatting.AQUA), ModKeys.getKeyBinding(ModKeys.KEY.ACTION2).func_238171_j_().func_230531_f_().func_240699_a_(TextFormatting.AQUA)}), (int)0, (int)((int)((double)this.field_230709_l_ * 0.8)), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)(this.field_230708_k_ / 4), (FontRenderer)this.field_230712_o_);
        }
    }

    @Override
    protected void afterIconDraw(MatrixStack stack, IAction p, int x, int y) {
        if (p == fakeAction || this.editActions) {
            return;
        }
        float active = this.actionHandler.getPercentageForAction(p);
        if (active > 0.0f) {
            float h = active * 16.0f;
            this.func_238468_a_(stack, x, (int)((float)y + h), x + 16, y + 16, Color.YELLOW.getRGB() - -2013265920, Color.YELLOW.getRGB());
        } else if (active < 0.0f) {
            float h = (1.0f + active) * 16.0f;
            this.func_238468_a_(stack, x, (int)((float)y + h), x + 16, y + 16, Color.BLACK.getRGB() - 0x55000000, Color.BLACK.getRGB());
        }
    }

    @Override
    @Nonnull
    protected Color getColor(IAction s) {
        if (s == fakeAction) {
            return super.getColor(s);
        }
        if (this.editActions) {
            if (SELECTEDACTION != null && (s == SELECTEDACTION || this.getSelectedElement() >= 0 && this.elements.get(this.getSelectedElement()) == s)) {
                return Color.GREEN;
            }
            return Color.WHITE;
        }
        if (!this.field_230706_i_.field_71439_g.func_70089_S()) {
            return Color.RED;
        }
        IFactionPlayer factionPlayer = FactionPlayerHandler.get((PlayerEntity)this.field_230706_i_.field_71439_g).getCurrentFactionPlayer().orElse(null);
        if (s.canUse(factionPlayer) != IAction.PERM.ALLOWED || this.actionHandler.getPercentageForAction(s) < 0.0f) {
            return Color.RED;
        }
        if (this.actionHandler.getPercentageForAction(s) > 0.0f) {
            return Color.YELLOW;
        }
        return super.getColor(s);
    }

    @Override
    protected ResourceLocation getIconLoc(IAction item) {
        if (item == fakeAction) {
            return new ResourceLocation("vampirism", "textures/actions/cancel.png");
        }
        return new ResourceLocation(item.getRegistryName().func_110624_b(), "textures/actions/" + item.getRegistryName().func_110623_a() + ".png");
    }

    @Override
    protected KeyBinding getMenuKeyBinding() {
        return ModKeys.getKeyBinding(ModKeys.KEY.ACTION);
    }

    @Override
    protected ITextComponent getName(IAction item) {
        return item.getName();
    }

    @Override
    protected void onElementSelected(IAction action) {
        if (action != fakeAction && action.canUse(FactionPlayerHandler.get((PlayerEntity)this.field_230706_i_.field_71439_g).getCurrentFactionPlayer().orElse(null)) == IAction.PERM.ALLOWED) {
            VampirismMod.dispatcher.sendToServer(CToggleActionPacket.createFromRaytrace(action.getRegistryName(), Minecraft.func_71410_x().field_71476_x));
        }
    }

    @Override
    protected void onGuiInit() {
        IFactionPlayer player = FactionPlayerHandler.get((PlayerEntity)this.field_230706_i_.field_71439_g).getCurrentFactionPlayer().orElse(null);
        this.actionHandler = player.getActionHandler();
        this.updateElements();
    }

    private boolean checkBinding(Function<KeyBinding, Boolean> func) {
        if (this.elements.get(this.getSelectedElement()) == fakeAction) {
            return true;
        }
        if (func.apply(ModKeys.getKeyBinding(ModKeys.KEY.ACTION1)).booleanValue() && ModKeys.getKeyBinding(ModKeys.KEY.ACTION1).getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.setBinding(1);
            return true;
        }
        if (func.apply(ModKeys.getKeyBinding(ModKeys.KEY.ACTION2)).booleanValue() && ModKeys.getKeyBinding(ModKeys.KEY.ACTION2).getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.setBinding(2);
            return true;
        }
        if (func.apply(ModKeys.getKeyBinding(ModKeys.KEY.ACTION3)).booleanValue() && ModKeys.getKeyBinding(ModKeys.KEY.ACTION3).getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.setBinding(3);
            return true;
        }
        return false;
    }

    private ImmutableList<IAction> getActionOrdered(List<IAction> toSort) {
        ArrayList ordered = Lists.newArrayList();
        if (ACTIONORDER.isEmpty()) {
            ACTIONORDER.addAll(ModRegistries.ACTIONS.getValues());
        }
        for (IAction a : ACTIONORDER) {
            if (!toSort.contains(a)) continue;
            ordered.add(a);
            toSort.remove(a);
        }
        ordered.addAll(toSort);
        return ImmutableList.copyOf((Collection)ordered);
    }

    private void setBinding(int id) {
        IAction action = (IAction)this.elements.get(this.getSelectedElement());
        FactionPlayerHandler.get((PlayerEntity)this.field_230706_i_.field_71439_g).setBoundAction(id, action, false, true);
        VampirismMod.dispatcher.sendToServer(new CActionBindingPacket(id, action));
        if (!this.editActions) {
            GLFW.glfwSetCursorPos((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (double)((float)this.field_230706_i_.func_228018_at_().func_198105_m() / 2.0f), (double)((float)this.field_230706_i_.func_228018_at_().func_198083_n() / 2.0f));
            this.func_231175_as__();
        }
    }

    private void switchActions(IAction first, IAction second) {
        if (first == second) {
            return;
        }
        int a = ACTIONORDER.indexOf(first);
        int b = ACTIONORDER.indexOf(second);
        ACTIONORDER.set(a, second);
        ACTIONORDER.set(b, first);
    }

    private void updateElements() {
        this.elements.clear();
        this.elements.addAll(this.getActionOrdered(this.actionHandler.getUnlockedActions().stream().filter(a -> a.showInSelectAction((PlayerEntity)this.field_230706_i_.field_71439_g)).collect(Collectors.toList())));
        this.elements.add(fakeAction);
    }
}

