/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class VampireBookScreen
extends Screen {
    private static final ResourceLocation pageTexture = new ResourceLocation("vampirism", "textures/gui/vampire_book.png");
    private final int xSize = 245;
    private final int ySize = 192;
    private int guiLeft;
    private int guiTop;
    private ChangePageButton buttonNext;
    private ChangePageButton buttonPrev;
    private int pageNumber;
    private final VampireBookManager.BookInfo info;
    private List<ITextProperties> content;

    public VampireBookScreen(VampireBookManager.BookInfo info) {
        super((ITextComponent)new StringTextComponent(info.getTitle()));
        this.info = info;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(pageTexture);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, 245, 192);
        this.pageNumber = MathHelper.func_76125_a((int)this.pageNumber, (int)0, (int)(this.content.size() - 1));
        if (this.pageNumber < this.content.size()) {
            ITextProperties toDraw = this.content.get(this.pageNumber);
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List cutLines = fontRenderer.func_238425_b_(toDraw, 170);
            int y = this.guiTop + 12 + 5;
            for (IReorderingProcessor cut : cutLines) {
                fontRenderer.func_238422_b_(stack, cut, (float)(this.guiLeft + 44), (float)y, 0);
                y += 10;
            }
        }
        VampireBookScreen.drawCenteredStringWithoutShadow(stack, this.field_230712_o_, String.format("%d/%d", this.pageNumber + 1, this.content.size()), this.guiLeft + 122, this.guiTop + 160, 0);
        VampireBookScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.guiLeft + 122), (int)(this.guiTop - 10), (int)Color.WHITE.getRGB());
        this.buttonPrev.field_230694_p_ = this.pageNumber != 0;
        this.buttonNext.field_230694_p_ = this.pageNumber != this.content.size() - 1 && !this.content.isEmpty();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.buttonNext = new ChangePageButton(this.guiLeft + 163, this.guiTop + 160, true, btn -> {
            if (this.pageNumber + 1 < this.content.size()) {
                this.nextPage();
            }
        }, true);
        this.func_230480_a_((Widget)this.buttonNext);
        this.buttonPrev = new ChangePageButton(this.guiLeft + 49, this.guiTop + 160, false, btn -> {
            if (this.pageNumber > 0) {
                this.prevPage();
            }
        }, true);
        this.func_230480_a_((Widget)this.buttonPrev);
        this.content = Arrays.stream(this.info.getContent()).map(StringTextComponent::new).flatMap(v -> VampireBookScreen.prepareForLongText((ITextProperties)v, 164, 120, 120).stream()).collect(Collectors.toList());
    }

    public static void drawCenteredStringWithoutShadow(MatrixStack p_238471_0_, FontRenderer p_238471_1_, String p_238471_2_, int p_238471_3_, int p_238471_4_, int p_238471_5_) {
        p_238471_1_.func_238421_b_(p_238471_0_, p_238471_2_, (float)(p_238471_3_ - p_238471_1_.func_78256_a(p_238471_2_) / 2), (float)p_238471_4_, p_238471_5_);
    }

    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.field_230706_i_.field_71474_y.field_74313_G.getKey().func_197937_c()) {
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.pageNumber + 1 < this.content.size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.pageNumber > 0) {
            this.prevPage();
            return true;
        }
        return super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void nextPage() {
        if (this.pageNumber != this.content.size() - 1 && !this.content.isEmpty()) {
            ++this.pageNumber;
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }

    private static List<ITextProperties> prepareForLongText(ITextProperties text, int lineWidth, int firstHeight, int subsequentHeight) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.getClass();
        int firstCount = firstHeight / 9;
        fontRenderer.getClass();
        int count = subsequentHeight / 9;
        ArrayList<ITextProperties> lines = new ArrayList<ITextProperties>(fontRenderer.func_238420_b_().func_238362_b_(text, lineWidth, Style.field_240709_b_));
        ArrayList<ITextProperties> pages = new ArrayList<ITextProperties>();
        ArrayList<ITextProperties> pageLines = lines.size() > firstCount ? lines.subList(0, firstCount) : lines;
        pages.add(VampireBookScreen.combineWithNewLine(pageLines));
        pageLines.clear();
        while (lines.size() > 0) {
            pageLines = lines.size() > count ? lines.subList(0, count) : lines;
            pages.add(VampireBookScreen.combineWithNewLine(pageLines));
            pageLines.clear();
        }
        return pages;
    }

    private static ITextProperties combineWithNewLine(List<ITextProperties> elements) {
        StringTextComponent newLine = new StringTextComponent("\n");
        ArrayList<Object> copy = new ArrayList<Object>(elements.size() * 2);
        for (int i = 0; i < elements.size() - 1; ++i) {
            copy.add(elements.get(i));
            copy.add(newLine);
        }
        copy.add(elements.get(elements.size() - 1));
        return ITextProperties.func_240654_a_(copy);
    }
}

