/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.client.render.entities.VampireMinionRenderer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.CAppearancePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class VampireMinionAppearanceScreen
extends AppearanceScreen<VampireMinionEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.minion_appearance");
    private int skinType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private ScrollableArrayTextComponentList typeList;
    private ExtendedButton typeButton;
    private CheckboxButton lordSkinButton;
    private TextFieldWidget nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public VampireMinionAppearanceScreen(VampireMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.typeList.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void func_231164_f_() {
        String name = this.nameWidget.func_146179_b();
        if (name.isEmpty()) {
            name = new TranslationTextComponent("text.vampirism.minion").getString() + ((VampireMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer(new CAppearancePacket(((VampireMinionEntity)this.entity).func_145782_y(), name, this.skinType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.func_231164_f_();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.nameWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.name")));
        this.nameWidget.func_146180_a(((VampireMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.func_146204_h(-1);
        this.nameWidget.func_146193_g(-1);
        this.nameWidget.func_146203_f(15);
        this.nameWidget.func_212954_a(this::onNameChanged);
        this.normalSkinCount = ((VampireMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getVampireTextureCount();
        this.minionSkinCount = ((VampireMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getMinionSpecificTextureCount();
        this.skinType = ((VampireMinionEntity)this.entity).getVampireType();
        this.isMinionSpecificSkin = ((VampireMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.useLordSkin = ((VampireMinionEntity)this.entity).shouldRenderLordSkin();
        this.typeList = (ScrollableArrayTextComponentList)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80, 20, this.normalSkinCount + this.minionSkinCount, (TextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.skin"), this::skin, this::previewSkin));
        this.typeButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.typeList.field_230690_l_, this.typeList.field_230691_m_ - 20, this.typeList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), button1 -> this.setListVisibility(!this.typeList.field_230694_p_)));
        this.lordSkinButton = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 64, 99, 20, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.use_lord_skin"), this.useLordSkin){

            public void func_230930_b_() {
                super.func_230930_b_();
                VampireMinionAppearanceScreen.this.useLordSkin = this.func_212942_a();
                ((VampireMinionEntity)VampireMinionAppearanceScreen.this.entity).setUseLordSkin(VampireMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.setListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((VampireMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((VampireMinionEntity)this.entity).setVampireType(type, minionSpecific);
        } else if (((VampireMinionEntity)this.entity).getVampireType() == type && ((VampireMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((VampireMinionEntity)this.entity).setVampireType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setListVisibility(boolean show) {
        this.typeButton.func_238482_a_((ITextComponent)this.typeList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.skinType + 1)));
        this.typeList.field_230694_p_ = show;
        this.lordSkinButton.field_230694_p_ = !show;
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((VampireMinionEntity)this.entity).setVampireType(this.skinType, this.isMinionSpecificSkin);
        this.setListVisibility(false);
    }
}

