/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.gui.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class VampireMinionStatsScreen
extends MinionStatsScreen<VampireMinionEntity.VampireMinionData, VampireMinionEntity> {
    private final TranslationTextComponent inventoryLevel = new TranslationTextComponent("text.vampirism.minion.stats.inventory_level");
    private final TranslationTextComponent healthLevel = new TranslationTextComponent(Attributes.field_233818_a_.func_233754_c_());
    private final TranslationTextComponent strengthLevel = new TranslationTextComponent(Attributes.field_233823_f_.func_233754_c_());
    private final TranslationTextComponent speedLevel = new TranslationTextComponent(Attributes.field_233821_d_.func_233754_c_());

    public VampireMinionStatsScreen(VampireMinionEntity entity, @Nullable Screen backScreen) {
        super(entity, 4, backScreen);
    }

    @Override
    protected boolean areButtonsVisible(VampireMinionEntity.VampireMinionData d) {
        return d.getRemainingStatPoints() > 0 || d.getLevel() < 6;
    }

    @Override
    protected int getRemainingStatPoints(VampireMinionEntity.VampireMinionData d) {
        return d.getRemainingStatPoints();
    }

    @Override
    protected boolean isActive(VampireMinionEntity.VampireMinionData data, int i) {
        switch (i) {
            case 0: {
                return data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2;
            }
            case 1: {
                return data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3;
            }
            case 2: {
                return data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3;
            }
            case 3: {
                return data.getRemainingStatPoints() > 0 && data.getSpeedLevel() < 3;
            }
        }
        return false;
    }

    @Override
    protected void renderStats(MatrixStack mStack, VampireMinionEntity.VampireMinionData data) {
        this.renderLevelRow(mStack, data.getLevel() + 1, 7);
        this.renderStatRow(mStack, 0, this.inventoryLevel, new StringTextComponent("" + data.getInventorySize()), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(mStack, 1, this.healthLevel, new StringTextComponent(String.format("%.1f", ((VampireMinionEntity)this.entity).func_110148_a(Attributes.field_233818_a_).func_111125_b())), data.getHealthLevel() + 1, 4);
        this.renderStatRow(mStack, 2, this.strengthLevel, new StringTextComponent(String.format("%.1f", ((VampireMinionEntity)this.entity).func_110148_a(Attributes.field_233823_f_).func_111125_b())), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(mStack, 3, this.speedLevel, new StringTextComponent(String.format("%.1f", ((VampireMinionEntity)this.entity).func_110148_a(Attributes.field_233821_d_).func_111125_b())), data.getSpeedLevel() + 1, 4);
    }
}

