/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWithDummyWidget;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.ExtendedScreen;
import de.teamlapen.vampirism.client.gui.SelectActionScreen;
import de.teamlapen.vampirism.client.gui.VampirePlayerAppearanceScreen;
import de.teamlapen.vampirism.client.gui.skills.SkillsScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.network.CDeleteRefinementPacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class VampirismScreen
extends ContainerScreen<VampirismContainer>
implements ExtendedScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/vampirism_menu.png");
    private static final ResourceLocation BACKGROUND_REFINEMENTS = new ResourceLocation("vampirism", "textures/gui/vampirism_menu_refinements.png");
    private final int display_width = 234;
    private final int display_height = 205;
    private final IFactionPlayer<?> factionPlayer;
    private int oldMouseX;
    private int oldMouseY;
    private ScrollableListWidget<ITaskInstance> list;
    private final Map<Integer, Button> refinementRemoveButtons = new Int2ObjectOpenHashMap(3);
    private ITextComponent level;

    public VampirismScreen(VampirismContainer container, PlayerInventory playerInventory, ITextComponent titleIn) {
        super((Container)container, playerInventory, titleIn);
        this.field_146999_f = 234;
        this.field_147000_g = 205;
        this.field_238744_r_ = 36;
        this.field_238745_s_ = this.field_147000_g - 93;
        ((VampirismContainer)this.field_147002_h).setReloadListener(() -> this.list.refresh());
        this.factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer(playerInventory.field_70458_d).orElseThrow(() -> new IllegalStateException("Cannot open Vampirism container without faction player"));
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.field_230707_j_;
    }

    @Override
    public TaskContainer getTaskContainer() {
        return (TaskContainer)this.field_147002_h;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (ModKeys.getKeyBinding(ModKeys.KEY.SKILL).func_197976_a(keyCode, scanCode)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        if (!this.field_147007_t) {
            this.list.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public Collection<ITaskInstance> refreshTasks() {
        return ((VampirismContainer)this.field_147002_h).getTaskInfos();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (((VampirismContainer)this.field_147002_h).areRefinementsAvailable()) {
            for (int i = 0; i < ((VampirismContainer)this.field_147002_h).getRefinementStacks().size(); ++i) {
                ItemStack stack = (ItemStack)((VampirismContainer)this.field_147002_h).getRefinementStacks().get(i);
                Slot slot = ((VampirismContainer)this.field_147002_h).func_75139_a(i);
                int x = slot.field_75223_e + this.field_147003_i;
                int y = slot.field_75221_f + this.field_147009_r;
                this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, stack, x, y);
                this.field_230707_j_.func_180453_a(this.field_230712_o_, stack, x, y, null);
            }
        }
        if (this.list.isEmpty()) {
            IFormattableTextComponent text = new TranslationTextComponent("gui.vampirism.vampirism_menu.no_tasks").func_240699_a_(TextFormatting.WHITE);
            int width = this.field_230712_o_.func_238414_a_((ITextProperties)text);
            this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)text, (float)(this.field_147003_i + 152 - width / 2), (float)(this.field_147009_r + 52), 0);
        }
        this.renderAccessorySlots(matrixStack, mouseX, mouseY, partialTicks);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        this.list.func_230443_a_(matrixStack, mouseX, mouseY);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (((VampirismContainer)this.field_147002_h).areRefinementsAvailable()) {
            this.renderHoveredRefinementTooltip(matrixStack, mouseX, mouseY);
        }
    }

    protected void renderAccessorySlots(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((VampirismContainer)this.field_147002_h).field_75151_b) {
            if (!this.func_195362_a(slot, mouseX, mouseY) || !(slot instanceof VampirismContainer.RemovingSelectorSlot) || ((ItemStack)((VampirismContainer)this.field_147002_h).getRefinementStacks().get(slot.getSlotIndex())).func_190926_b()) continue;
            this.refinementRemoveButtons.get(slot.getSlotIndex()).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.level = this.factionPlayer.getLevel() > 0 ? FactionPlayerHandler.getOpt(this.factionPlayer.getRepresentingPlayer()).filter(f -> f.getLordLevel() > 0).map(f -> f.getLordTitle().func_230532_e_().func_240702_b_(" (" + f.getLordLevel() + ")")).orElseGet(() -> new TranslationTextComponent("text.vampirism.level").func_240702_b_(" " + this.factionPlayer.getLevel())).func_240699_a_(this.factionPlayer.getFaction().getChatColor()) : StringTextComponent.field_240750_d_;
        this.list = new ScrollableListWithDummyWidget<ITaskInstance>(this.field_147003_i + 83, this.field_147009_r + 7, 145, 104, 21, this::refreshTasks, (item, list1, isDummy) -> new TaskItem((ITaskInstance)item, list1, isDummy, this, this.factionPlayer));
        this.func_230480_a_((Widget)this.list);
        this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 5, this.field_147009_r + 90, 20, 20, 40, 205, 20, BACKGROUND, 256, 256, context -> {
            if (this.field_230706_i_.field_71439_g.func_70089_S() && VampirismPlayerAttributes.get((PlayerEntity)this.field_230706_i_.field_71439_g).faction != null) {
                Minecraft.func_71410_x().func_147108_a((Screen)new SkillsScreen(FactionPlayerHandler.getCurrentFactionPlayer((PlayerEntity)this.field_230706_i_.field_71439_g).orElse(null), (Screen)this));
            }
        }, (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.skill_screen"), mouseX, mouseY), StringTextComponent.field_240750_d_));
        this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 26, this.field_147009_r + 90, 20, 20, 0, 205, 20, BACKGROUND, 256, 256, context -> {
            IPlayableFaction<IFactionPlayer<?>> factionNew = VampirismPlayerAttributes.get((PlayerEntity)this.field_230706_i_.field_71439_g).faction;
            Minecraft.func_71410_x().func_147108_a((Screen)new SelectActionScreen(factionNew.getColor(), true));
        }, (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.edit_actions"), mouseX, mouseY), StringTextComponent.field_240750_d_));
        Button appearanceButton = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 47, this.field_147009_r + 90, 20, 20, 20, 205, 20, BACKGROUND, 256, 256, context -> Minecraft.func_71410_x().func_147108_a((Screen)new VampirePlayerAppearanceScreen((Screen)this)), (button1, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.appearance_menu"), mouseX, mouseY), StringTextComponent.field_240750_d_));
        if (!Helper.isVampire((PlayerEntity)this.field_230706_i_.field_71439_g)) {
            appearanceButton.field_230693_o_ = false;
            appearanceButton.field_230694_p_ = false;
        }
        final NonNullList<ItemStack> refinementList = ((VampirismContainer)this.field_147002_h).getRefinementStacks();
        for (final Slot slot : ((VampirismContainer)this.field_147002_h).field_75151_b) {
            if (!(slot instanceof VampirismContainer.RemovingSelectorSlot)) continue;
            Button xButton = (Button)this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() + slot.field_75223_e + 16 - 5, this.getGuiTop() + slot.field_75221_f + 16 - 5, 5, 5, 60, 205, 0, BACKGROUND_REFINEMENTS, 256, 256, button -> {
                VampirismMod.dispatcher.sendToServer(new CDeleteRefinementPacket(IRefinementItem.AccessorySlotType.values()[slot.field_75222_d]));
                refinementList.set(slot.field_75222_d, (Object)ItemStack.field_190927_a);
            }, (button12, matrixStack, xPos, yPos) -> this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.destroy_item").func_240699_a_(TextFormatting.RED), xPos, yPos), StringTextComponent.field_240750_d_){

                public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230694_p_ = !((ItemStack)refinementList.get(slot.field_75222_d)).func_190926_b() && VampirismScreen.this.field_147012_x.func_190926_b() && this.overSlot(slot, mouseX, mouseY);
                    super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }

                private boolean overSlot(Slot slot2, int mouseX, int mouseY) {
                    return slot2.field_75223_e <= (mouseX -= VampirismScreen.this.field_147003_i) && slot2.field_75223_e + 16 > mouseX && slot2.field_75221_f <= (mouseY -= VampirismScreen.this.field_147009_r) && slot2.field_75221_f + 16 > mouseY;
                }
            });
            this.refinementRemoveButtons.put(slot.getSlotIndex(), xButton);
        }
    }

    protected void func_230451_b_(@Nonnull MatrixStack stack, int mouseX, int mouseY) {
        super.func_230451_b_(stack, mouseX, mouseY);
        int width = this.field_230712_o_.func_238414_a_((ITextProperties)this.level);
        this.field_230712_o_.func_243248_b(stack, this.level, Math.max(5.0f, 31.0f - (float)width / 2.0f), 81.0f, -1);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float v, int i, int i1) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(((VampirismContainer)this.field_147002_h).areRefinementsAvailable() ? BACKGROUND_REFINEMENTS : BACKGROUND);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        InventoryScreen.func_228187_a_((int)(this.field_147003_i + 31), (int)(this.field_147009_r + 72), (int)30, (float)((float)(this.field_147003_i + 10) - (float)this.oldMouseX), (float)((float)(this.field_147009_r + 75 - 50) - (float)this.oldMouseY), (LivingEntity)this.field_230706_i_.field_71439_g);
    }

    protected void renderHoveredRefinementTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
        NonNullList<ItemStack> list;
        int index;
        if (this.field_147006_u != null && (index = this.field_147006_u.field_75222_d) < (list = ((VampirismContainer)this.field_147002_h).getRefinementStacks()).size() && index >= 0) {
            if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && !((ItemStack)list.get(index)).func_190926_b()) {
                if (!this.refinementRemoveButtons.get(this.field_147006_u.getSlotIndex()).func_230449_g_()) {
                    this.func_230457_a_(matrixStack, (ItemStack)list.get(index), mouseX, mouseY);
                }
            } else if (!((ItemStack)list.get(index)).func_190926_b() && ((VampirismContainer)this.field_147002_h).func_75139_a(index).func_75214_a(this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o())) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.destroy_item").func_240699_a_(TextFormatting.RED), mouseX, mouseY);
            }
        }
    }

    private class TaskItem
    extends de.teamlapen.vampirism.client.gui.widget.TaskItem<VampirismScreen> {
        private ImageButton button;

        public TaskItem(ITaskInstance item, ScrollableListWithDummyWidget<ITaskInstance> list, boolean isDummy, VampirismScreen screen, IFactionPlayer<?> factionPlayer) {
            super(item, list, isDummy, screen, factionPlayer);
            if (!item.isUnique()) {
                this.button = new ImageButton(0, 0, 8, 11, 0, 229, 11, TASKMASTER_GUI_TEXTURE, 256, 256, this::onClick, this::onTooltip, StringTextComponent.field_240750_d_);
            }
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            if (this.button != null && !this.isDummy && mouseX > (double)this.button.field_230690_l_ && mouseX < (double)(this.button.field_230690_l_ + this.button.func_230998_h_()) && mouseY > (double)this.button.field_230691_m_ && mouseY < (double)(this.button.field_230691_m_ + this.button.func_238483_d_())) {
                this.button.func_230982_a_(mouseX, mouseY);
                return true;
            }
            return super.onClick(mouseX, mouseY);
        }

        @Override
        public void renderItem(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.renderItem(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, partialTicks, zLevel);
            if (this.button != null) {
                this.button.field_230690_l_ = x + listWidth - 13;
                this.button.field_230691_m_ = y + 1;
                this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public void renderItemToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
            if (this.button != null && this.button.func_230449_g_()) {
                this.button.func_230443_a_(matrixStack, mouseX, mouseY);
            } else {
                super.renderItemToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            }
        }

        private float getDistance(int x1, int z1, int x2, int z2) {
            int i = x2 - x1;
            int j = z2 - z1;
            return MathHelper.func_76129_c((float)(i * i + j * j));
        }

        private void onClick(Button button) {
            PlayerEntity player = this.factionPlayer.getRepresentingPlayer();
            ITextComponent position = (ITextComponent)((VampirismContainer)((VampirismScreen)VampirismScreen.this).field_147002_h).taskWrapper.get(((ITaskInstance)this.item).getTaskBoard()).getLastSeenPos().map(pos -> {
                int i = MathHelper.func_76141_d((float)this.getDistance(player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177952_p(), pos.func_177958_n(), pos.func_177952_p()));
                IFormattableTextComponent itextcomponent = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), "~", pos.func_177952_p()})).func_240700_a_(p_241055_1_ -> p_241055_1_.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_177958_n() + " ~ " + pos.func_177952_p())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip"))));
                return itextcomponent.func_230529_a_((ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.distance", new Object[]{i}));
            }).orElseGet(() -> new TranslationTextComponent("gui.vampirism.vampirism_menu.last_known_pos.unknown").func_240699_a_(TextFormatting.GOLD));
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.last_known_pos").func_230529_a_(position), false);
        }

        private void onTooltip(Button button, MatrixStack matrixStack, int mouseX, int mouseY) {
            ITextComponent position = (ITextComponent)((VampirismContainer)((VampirismScreen)VampirismScreen.this).field_147002_h).taskWrapper.get(((ITaskInstance)this.item).getTaskBoard()).getLastSeenPos().map(pos -> new StringTextComponent("[" + pos.func_229422_x_() + "]").func_240699_a_(TextFormatting.GREEN)).orElseGet(() -> new TranslationTextComponent("gui.vampirism.vampirism_menu.last_known_pos.unknown").func_240699_a_(TextFormatting.GOLD));
            VampirismScreen.this.renderWrappedToolTip(matrixStack, Collections.singletonList(new TranslationTextComponent("gui.vampirism.vampirism_menu.last_known_pos").func_230529_a_(position)), mouseX, mouseY, VampirismScreen.this.field_230712_o_);
        }
    }
}

