/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.skills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.gui.skills.SkillsScreen;
import de.teamlapen.vampirism.client.gui.skills.SkillsTabScreen;
import de.teamlapen.vampirism.player.skills.ActionSkill;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.skills.SkillNode;
import de.teamlapen.vampirism.player.skills.SkillTree;
import de.teamlapen.vampirism.player.skills.SkillTreeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
@ParametersAreNonnullByDefault
public class SkillNodeScreen
extends AbstractGui {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("vampirism", "textures/gui/skills/widgets.png");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final Minecraft minecraft;
    private final SkillsTabScreen tab;
    private final SkillsScreen screen;
    private final SkillNode skillNode;
    private final SkillHandler<?> skillHandler;
    private final List<SkillNodeScreen> children = new ArrayList<SkillNodeScreen>();
    @Nullable
    private final SkillNodeScreen parent;
    private final int x;
    private final int y;
    private final IReorderingProcessor[] titles;
    private final List<IReorderingProcessor>[] descriptions;
    private final int[] width;

    public SkillNodeScreen(Minecraft minecraft, SkillsScreen screen, SkillsTabScreen tab, SkillNode skillNode, SkillHandler<?> skillHandler) {
        this(minecraft, screen, tab, skillNode, skillHandler, null, 0, 0);
    }

    public SkillNodeScreen(Minecraft minecraft, SkillsScreen screen, SkillsTabScreen tab, SkillNode skillNode, SkillHandler<?> skillHandler, @Nullable SkillNodeScreen parent, int x, int y) {
        int i;
        this.minecraft = minecraft;
        this.tab = tab;
        this.screen = screen;
        this.skillNode = skillNode;
        this.skillHandler = skillHandler;
        this.parent = parent;
        this.x = x;
        this.y = y;
        int w = SkillTree.getTreeWidth(skillNode);
        int childrenCount = this.skillNode.getChildren().size();
        if (childrenCount > 0) {
            int pos = x;
            if (--childrenCount > 0) {
                pos -= w / 2 - 13;
            }
            for (i = 0; i < skillNode.getChildren().size(); ++i) {
                SkillNode current = skillNode.getChildren().get(i);
                this.children.add(new SkillNodeScreen(minecraft, screen, tab, current, skillHandler, this, pos, y + 60));
                pos += SkillTree.getTreeWidth(current) / 2 + 30;
                if (skillNode.getChildren().size() < i + 2) continue;
                SkillNode next = skillNode.getChildren().get(i + 1);
                pos += SkillTree.getTreeWidth(next) / 2;
            }
        }
        this.titles = new IReorderingProcessor[skillNode.getElements().length];
        this.descriptions = new List[skillNode.getElements().length];
        this.width = new int[skillNode.getElements().length];
        int l = 56;
        for (i = 0; i < skillNode.getElements().length; ++i) {
            this.titles[i] = LanguageMap.func_74808_a().func_241870_a(minecraft.field_71466_p.func_238417_a_((ITextProperties)skillNode.getElements()[i].getName(), 163));
            int size = Math.max(l + minecraft.field_71466_p.func_243245_a(this.titles[i]), 120);
            this.descriptions[i] = LanguageMap.func_74808_a().func_244260_a(this.findOptimalLines((ITextComponent)TextComponentUtils.func_240648_a_((IFormattableTextComponent)Optional.ofNullable(skillNode.getElements()[i].getDescription()).orElse((ITextComponent)new StringTextComponent("")).func_230532_e_(), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)), size - 30));
            this.width[i] = size;
        }
    }

    private static float getMaxWidth(CharacterManager p_238693_0_, List<ITextProperties> p_238693_1_) {
        return (float)p_238693_1_.stream().mapToDouble(arg_0 -> ((CharacterManager)p_238693_0_).func_238356_a_(arg_0)).max().orElse(0.0);
    }

    private SkillNodeState getState() {
        block6: {
            block5: {
                if (Arrays.stream(this.skillNode.getElements()).anyMatch(this.skillHandler::isSkillEnabled)) {
                    return SkillNodeState.UNLOCKED;
                }
                if (this.skillHandler.isSkillNodeLocked(this.skillNode)) {
                    return SkillNodeState.LOCKED;
                }
                if (this.skillNode.getParent() == null) break block5;
                if (!Arrays.stream(this.skillNode.getParent().getElements()).anyMatch(this.skillHandler::isSkillEnabled)) break block6;
            }
            return SkillNodeState.AVAILABLE;
        }
        return this.skillNode.isHidden() ? SkillNodeState.HIDDEN : SkillNodeState.VISIBLE;
    }

    private Collection<ISkill> getLockingSkills(SkillNode node) {
        return Arrays.stream(node.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node2 -> Arrays.stream(node2.getElements())).filter(this.skillHandler::isSkillEnabled).collect(Collectors.toList());
    }

    public List<SkillNodeScreen> getChildren() {
        return this.children;
    }

    public SkillNode getSkillNode() {
        return this.skillNode;
    }

    public void draw(MatrixStack stack, int i, int j) {
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, 0.0, 50.0);
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        int width = 26 * this.skillNode.getElements().length + (this.skillNode.getElements().length - 1) * 10;
        this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
        int x = this.getNodeStart();
        if (this.skillNode.getElements().length > 1) {
            GuiUtils.drawContinuousTexturedBox((MatrixStack)stack, (int)(i + x), (int)(j + this.y), (int)200, (int)0, (int)width, (int)26, (int)26, (int)26, (int)3, (float)this.func_230927_p_());
        }
        for (int i1 = 0; i1 < this.skillNode.getElements().length; ++i1) {
            if (state == SkillNodeState.LOCKED || !this.skillHandler.isSkillEnabled(this.skillNode.getElements()[i1])) {
                RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
            this.func_238474_b_(stack, i + x, j + this.y, this.skillNode.isRoot() ? 226 : 200, 0, 26, 26);
            this.minecraft.field_71446_o.func_110577_a(this.getSkillIconLocation(this.skillNode.getElements()[i1]));
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            UtilLib.drawTexturedModalRect(stack.func_227866_c_().func_227870_a_(), this.func_230927_p_(), x + i + 5, this.y + j + 5, 0, 0, 16, 16, 16, 16);
            RenderSystem.disableLighting();
            x += 36;
        }
        for (SkillNodeScreen child : this.children) {
            child.draw(stack, i, j);
        }
        stack.func_227865_b_();
    }

    public void drawConnectivity(MatrixStack stack, int startX, int startY, boolean outerLine) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        if (this.parent != null) {
            int color = state.pathColor(outerLine);
            stack.func_227860_a_();
            if (state == SkillNodeState.UNLOCKED) {
                stack.func_227861_a_(0.0, 0.0, 10.0);
            }
            int i = startX + this.x + 13;
            int i1 = startX + this.parent.x + 13;
            int j = startY + this.y - 30;
            int j2 = startY + this.parent.y + 13;
            int j3 = startY + this.y - 29;
            int j4 = startY + this.parent.y + 13 + 16;
            int i2 = startX + this.x + 13;
            int j5 = startY + this.y;
            int i3 = startX + this.parent.x + 13;
            if (outerLine) {
                this.func_238465_a_(stack, i, i1, j - 1, color);
                this.func_238465_a_(stack, i, i1, j + 1, color);
                this.func_238473_b_(stack, i1 - 1, j2, j3, color);
                this.func_238473_b_(stack, i3 + 1, j2, j3, color);
                this.func_238473_b_(stack, i - 1, j4, j5 + 1, color);
                this.func_238473_b_(stack, i2 + 1, j4, j5 + 1, color);
            } else {
                this.func_238465_a_(stack, i, i1, j, color);
                this.func_238473_b_(stack, i1, j2, j3, color);
                this.func_238473_b_(stack, i, j4, j5 + 1, color);
            }
            stack.func_227865_b_();
        }
        for (SkillNodeScreen child : this.children) {
            child.drawConnectivity(stack, startX, startY, outerLine);
        }
    }

    public void drawHover(MatrixStack stack, double mouseX, double mouseY, float fade, int scrollX, int scrollY) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
        ISkill[] elements = this.skillNode.getElements();
        int hoveredSkill = -1;
        for (int i = 0; i < elements.length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, scrollX, scrollY)) continue;
            hoveredSkill = i;
            break;
        }
        if (hoveredSkill != -1) {
            int x = this.getNodeStart() + 36 * hoveredSkill;
            Collection<ISkill> lockingSkills = this.getLockingSkills(this.skillNode);
            if (state == SkillNodeState.LOCKED || state == SkillNodeState.VISIBLE) {
                ArrayList<Object> text = new ArrayList<Object>();
                if (state == SkillNodeState.VISIBLE) {
                    IFormattableTextComponent t1 = new TranslationTextComponent("text.vampirism.skill.unlock_parent_first").func_240699_a_(TextFormatting.DARK_RED);
                    text.add(t1);
                } else {
                    text.add(new TranslationTextComponent("text.vampirism.skill.locked"));
                    lockingSkills.stream().map(a -> a.getName().func_230532_e_().func_240699_a_(TextFormatting.DARK_RED)).forEach(text::add);
                }
                int width = text.stream().mapToInt(arg_0 -> ((FontRenderer)this.minecraft.field_71466_p).func_238414_a_(arg_0)).max().getAsInt();
                this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
                GuiUtils.drawContinuousTexturedBox((MatrixStack)stack, (int)(scrollX + x - 3), (int)(scrollY + this.y - 3 - text.size() * 9), (int)0, (int)81, (int)(width + 8), (int)(10 + text.size() * 10), (int)200, (int)20, (int)3, (float)this.func_230927_p_());
                int fontY = scrollY + this.y + 1 - text.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    this.minecraft.field_71466_p.func_243246_a(stack, (ITextComponent)text.get(i), (float)(scrollX + x + 2), (float)(fontY + i * 9), -1);
                }
            }
            List<IReorderingProcessor> description = this.descriptions[hoveredSkill];
            if (!lockingSkills.isEmpty()) {
                ArrayList<TranslationTextComponent> text = new ArrayList<TranslationTextComponent>();
                text.add(new TranslationTextComponent("text.vampirism.skill.excluding"));
                lockingSkills.stream().map(a -> a.getName().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).forEach(text::add);
                int width = Math.min(this.width[hoveredSkill], text.stream().mapToInt(arg_0 -> ((FontRenderer)this.minecraft.field_71466_p).func_238414_a_(arg_0)).max().getAsInt());
                this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
                int yOffset = description.isEmpty() ? 15 : 24;
                GuiUtils.drawContinuousTexturedBox((MatrixStack)stack, (int)(scrollX + x - 3), (int)(scrollY + this.y + 3 + 7 + description.size() * 9), (int)0, (int)81, (int)(width + 8), (int)(text.size() * 10 + yOffset), (int)200, (int)20, (int)3, (float)this.func_230927_p_());
                int fontY = scrollY + this.y + 3 + yOffset + 8 + description.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    this.minecraft.field_71466_p.func_243246_a(stack, (ITextComponent)text.get(i), (float)(scrollX + x + 2), (float)(fontY + i * 9), -1);
                }
            }
            if (!description.isEmpty()) {
                this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
                GuiUtils.drawContinuousTexturedBox((MatrixStack)stack, (int)(scrollX + x - 5), (int)(scrollY + this.y + 3), (int)0, (int)81, (int)this.width[hoveredSkill], (int)(30 + description.size() * 9), (int)200, (int)20, (int)3, (float)this.func_230927_p_());
                for (int i = 0; i < description.size(); ++i) {
                    this.minecraft.field_71466_p.func_238407_a_(stack, description.get(i), (float)(scrollX + x + 2), (float)(scrollY + this.y + 3 + 24 + i * 9), -1);
                }
            }
            this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
            int wid = this.width[hoveredSkill] / 2;
            int titleTextureY = state.titleTextureY;
            if (state == SkillNodeState.UNLOCKED && !this.skillHandler.isSkillEnabled(elements[hoveredSkill])) {
                titleTextureY = SkillNodeState.LOCKED.titleTextureY;
            }
            this.func_238474_b_(stack, scrollX + x - 5, scrollY + this.y + 3, 0, titleTextureY, wid, 22);
            this.func_238474_b_(stack, scrollX + x - 5 + wid, scrollY + this.y + 3, 200 - wid, titleTextureY, wid, 22);
            this.minecraft.field_71466_p.func_238407_a_(stack, this.titles[hoveredSkill], (float)(scrollX + x + 40), (float)(scrollY + this.y + 9), -1);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(WIDGETS_LOCATION);
            this.func_238474_b_(stack, scrollX + x, scrollY + this.y, this.skillNode.isRoot() ? 226 : 200, 0, 26, 26);
            this.minecraft.field_71446_o.func_110577_a(this.getSkillIconLocation(elements[hoveredSkill]));
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            UtilLib.drawTexturedModalRect(stack.func_227866_c_().func_227870_a_(), this.func_230927_p_(), x + scrollX + 5, this.y + scrollY + 5, 0, 0, 16, 16, 16, 16);
            RenderSystem.disableLighting();
        }
    }

    private List<IReorderingProcessor> getSkillDescription(int skill) {
        List<IReorderingProcessor> description = this.descriptions[skill];
        ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled(this.skillNode.getElements()[skill]);
        List<ISkill> lockingSkills = null;
        TextFormatting lockingColor = TextFormatting.BLACK;
        if (this.skillNode.getLockingNodes().length != 0) {
            lockingSkills = this.skillHandler.getLockingSkills(this.skillNode);
            TextFormatting textFormatting = result == ISkillHandler.Result.ALREADY_ENABLED ? TextFormatting.DARK_GRAY : (lockingColor = lockingSkills.stream().anyMatch(this.skillHandler::isSkillEnabled) ? TextFormatting.DARK_RED : TextFormatting.YELLOW);
        }
        if (lockingSkills != null) {
            int l = 56;
            int size = Math.max(l + this.minecraft.field_71466_p.func_243245_a(this.titles[skill]), 120) - 20;
            description = new ArrayList<IReorderingProcessor>(description);
            description.addAll(LanguageMap.func_74808_a().func_244260_a(this.findOptimalLines((ITextComponent)new TranslationTextComponent("text.vampirism.skill.excluding").func_240699_a_(lockingColor), size)));
            for (ISkill lockingSkill : lockingSkills) {
                description.addAll(LanguageMap.func_74808_a().func_244260_a(this.findOptimalLines((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)lockingSkill.getName().func_230532_e_().func_240699_a_(lockingColor)), size)));
            }
        }
        return description;
    }

    private ResourceLocation getSkillIconLocation(ISkill skill) {
        if (skill instanceof ActionSkill) {
            return new ResourceLocation(((ActionSkill)skill).getActionID().func_110624_b(), "textures/actions/" + ((ActionSkill)skill).getActionID().func_110623_a() + ".png");
        }
        return new ResourceLocation(skill.getRegistryName().func_110624_b(), "textures/skills/" + skill.getRegistryName().func_110623_a() + ".png");
    }

    public boolean isMouseOver(double mouseX, double mouseY, int scrollX, int scrollY) {
        double width = 26 * this.skillNode.getElements().length + (this.skillNode.getElements().length - 1) * 10;
        return mouseX >= (double)(this.x + scrollX) - width / 2.0 + 13.0 && mouseX < (double)(this.x + scrollX + 13) + width / 2.0 - 1.0 && mouseY > (double)(scrollY + this.y) && mouseY < (double)(scrollY + this.y + 26);
    }

    public boolean isMouseOverSkill(int index, double mouseX, double mouseY, int guiLeft, int guiTop) {
        int x = this.getNodeStart() + 36 * index;
        return mouseX > (double)(x + guiLeft) && mouseX < (double)(x + guiLeft + 26) && mouseY > (double)(guiTop + this.y) && mouseY < (double)(guiTop + this.y + 26);
    }

    @Nullable
    public ISkill getSelectedSkill(double mouseX, double mouseY, int scrollX, int scrollY) {
        if (!this.isMouseOver(mouseX, mouseY, scrollX, scrollY)) {
            return null;
        }
        for (int i = 0; i < this.skillNode.getElements().length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, scrollX, scrollY)) continue;
            return this.skillNode.getElements()[i];
        }
        return null;
    }

    private int getNodeStart() {
        int x = this.x;
        if (this.skillNode.getElements().length > 1) {
            if (this.skillNode.getElements().length % 2 == 0) {
                x -= this.skillNode.getElements().length / 2 * 26;
                x -= (this.skillNode.getElements().length - 1) / 2 * 8;
                x -= 2 * (this.skillNode.getElements().length / 2);
                x += 10;
            } else {
                x -= (this.skillNode.getElements().length - 1) / 2 * 26;
                x -= (this.skillNode.getElements().length - 1) / 2 * 10;
            }
        }
        return x;
    }

    private List<ITextProperties> findOptimalLines(ITextComponent p_238694_1_, int p_238694_2_) {
        CharacterManager charactermanager = this.minecraft.field_71466_p.func_238420_b_();
        List list = Collections.emptyList();
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list1 = charactermanager.func_238362_b_((ITextProperties)p_238694_1_, p_238694_2_ - i, Style.field_240709_b_);
            float f1 = Math.abs(SkillNodeScreen.getMaxWidth(charactermanager, list1) - (float)p_238694_2_);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    static enum SkillNodeState {
        AVAILABLE(3, -5789785, -1),
        HIDDEN(0, 0, 0),
        LOCKED(55, -3211264, -9830400),
        UNLOCKED(29, -16742639, -16755964),
        VISIBLE(3, -14540254, -12632257);

        public final int titleTextureY;
        public final int innerColor;
        public final int outerColor;

        private SkillNodeState(int titleTextureY, int innerColor, int outerColor) {
            this.titleTextureY = titleTextureY;
            this.outerColor = outerColor;
            this.innerColor = innerColor;
        }

        int pathColor(boolean outer) {
            return outer ? this.outerColor : this.innerColor;
        }
    }
}

