/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.skills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.client.gui.skills.SkillsTabScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.CSimpleInputEvent;
import de.teamlapen.vampirism.network.CUnlockSkillPacket;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
@ParametersAreNonnullByDefault
public class SkillsScreen
extends Screen {
    public static final int SCREEN_WIDTH = 252;
    public static final int SCREEN_HEIGHT = 219;
    private static final ResourceLocation WINDOW_LOCATION = new ResourceLocation("vampirism", "textures/gui/skills/window.png");
    private static final ResourceLocation TABS_LOCATION = new ResourceLocation("textures/gui/advancements/tabs.png");
    private static final ITextComponent VERY_SAD_LABEL = new TranslationTextComponent("advancements.sad_label");
    private static final ITextComponent NO_TABS_LABEL = new TranslationTextComponent("gui.vampirism.skill_screen.no_tab");
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.vampirism.vampirism_menu.skill_screen");
    @Nullable
    private final IFactionPlayer<?> factionPlayer;
    private final List<SkillsTabScreen> tabs = new ArrayList<SkillsTabScreen>();
    @Nullable
    private final Screen backScreen;
    @Nullable
    private SkillsTabScreen selectedTab;
    @Nullable
    private Button resetSkills;
    private int guiLeft;
    private int guiTop;
    private boolean scrolling;
    @Nullable
    private Vector3d mousePos;
    private boolean clicked;

    public SkillsScreen(@Nullable IFactionPlayer<?> factionPlayer, @Nullable Screen backScreen) {
        super(NarratorChatListener.field_216868_a);
        this.factionPlayer = factionPlayer;
        this.backScreen = backScreen;
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        assert (this.field_230706_i_ != null);
        this.tabs.clear();
        this.guiLeft = (this.field_230708_k_ - 252) / 2;
        this.guiTop = (this.field_230709_l_ - 219) / 2;
        if (this.factionPlayer != null) {
            SkillNode rootNode = VampirismMod.proxy.getSkillTree(true).getRootNodeForFaction(this.factionPlayer.getFaction().getID(), SkillType.LEVEL);
            this.tabs.add(new SkillsTabScreen(this.field_230706_i_, this, 0, new ItemStack((IItemProvider)ModItems.VAMPIRE_BOOK.get()), rootNode, this.factionPlayer.getSkillHandler()));
            if (this.factionPlayer.getFaction().hasLordSkills() && FactionPlayerHandler.getOpt(this.factionPlayer.getRepresentingPlayer()).map(a -> a.getLordLevel() > 0).orElse(false).booleanValue()) {
                rootNode = VampirismMod.proxy.getSkillTree(true).getRootNodeForFaction(this.factionPlayer.getFaction().getID(), SkillType.LORD);
                this.tabs.add(new SkillsTabScreen(this.field_230706_i_, this, 1, new ItemStack((IItemProvider)ModItems.VAMPIRE_MINION_BINDING.get()), rootNode, this.factionPlayer.getSkillHandler()));
            }
        }
        if (this.tabs.size() > 0) {
            this.selectedTab = this.tabs.get(this.selectedTab == null ? 0 : this.selectedTab.getIndex());
        }
        if (this.backScreen != null) {
            this.func_230480_a_((Widget)new Button(this.guiLeft + 4, this.guiTop + 194, 80, 20, (ITextComponent)new TranslationTextComponent("gui.back"), context -> this.field_230706_i_.func_147108_a(this.backScreen)));
        }
        this.func_230480_a_((Widget)new Button(this.guiLeft + 168, this.guiTop + 194, 80, 20, (ITextComponent)new TranslationTextComponent("gui.done"), context -> this.field_230706_i_.func_147108_a(null)));
        FactionPlayerHandler.getOpt((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(fph -> fph.getCurrentFactionPlayer().ifPresent(factionPlayer -> {
            boolean test = VampirismMod.inDev || VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion();
            this.resetSkills = (Button)this.func_230480_a_((Widget)new Button(this.guiLeft + 85, this.guiTop + 194, 80, 20, (ITextComponent)new TranslationTextComponent("text.vampirism.skill.resetall"), context -> {
                VampirismMod.dispatcher.sendToServer(new CSimpleInputEvent(CSimpleInputEvent.Type.RESET_SKILLS));
                InventoryHelper.removeItemFromInventory((IInventory)factionPlayer.getRepresentingPlayer().field_71071_by, new ItemStack((IItemProvider)ModItems.OBLIVION_POTION.get()));
                if (!(factionPlayer.getLevel() >= 2 && this.field_230706_i_.field_71439_g.field_71071_by.func_213901_a((Item)ModItems.OBLIVION_POTION.get()) > 1 || test)) {
                    context.field_230693_o_ = false;
                }
            }, (button, stack, mouseX, mouseY) -> {
                if (button.field_230693_o_) {
                    this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("text.vampirism.skills.reset_consume", new Object[]{((OblivionItem)ModItems.OBLIVION_POTION.get()).func_200296_o()}), mouseX, mouseY);
                } else {
                    this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("text.vampirism.skills.reset_req", new Object[]{((OblivionItem)ModItems.OBLIVION_POTION.get()).func_200296_o()}), mouseX, mouseY);
                }
            }));
            if (!(factionPlayer.getLevel() >= 2 && this.field_230706_i_.field_71439_g.field_71071_by.func_213901_a((Item)ModItems.OBLIVION_POTION.get()) > 0 || test)) {
                this.resetSkills.field_230693_o_ = false;
            }
        }));
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.renderInside(stack, mouseX, mouseY, this.guiLeft, this.guiTop);
        this.renderWindow(stack, mouseX, mouseY, this.guiLeft, this.guiTop);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.renderTooltip(stack, mouseX, mouseY, this.guiLeft, this.guiTop);
    }

    public void renderInside(MatrixStack stack, int mouseX, int mouseY, int x, int y) {
        if (this.selectedTab != null) {
            stack.func_227860_a_();
            stack.func_227861_a_((double)(x + 9), (double)(y + 18), 0.0);
            this.selectedTab.drawContents(stack);
            stack.func_227865_b_();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        } else {
            stack.func_227860_a_();
            stack.func_227861_a_((double)(x + 9), (double)(y + 18), 0.0);
            SkillsScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)234, (int)192, (int)-16777216);
            int i = 117;
            SkillsScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)NO_TABS_LABEL, (int)i, (int)52, (int)-1);
            SkillsScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)VERY_SAD_LABEL, (int)i, (int)104, (int)-1);
            stack.func_227865_b_();
        }
    }

    public void renderWindow(MatrixStack stack, int mouseX, int mouseY, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.field_230706_i_.func_110434_K().func_110577_a(WINDOW_LOCATION);
        this.func_238474_b_(stack, x, y, 0, 0, 252, 219);
        if (this.tabs.size() > 1) {
            this.field_230706_i_.func_110434_K().func_110577_a(TABS_LOCATION);
            for (SkillsTabScreen skillTab : this.tabs) {
                skillTab.drawTab(stack, x, y, skillTab == this.selectedTab);
            }
            RenderSystem.enableRescaleNormal();
            RenderSystem.defaultBlendFunc();
            for (SkillsTabScreen skillTab : this.tabs) {
                skillTab.drawIcon(x, y, this.field_230707_j_);
            }
            RenderSystem.disableBlend();
        }
        if (this.selectedTab != null) {
            TranslationTextComponent remainingPoints = new TranslationTextComponent("text.vampirism.skills.points_left", new Object[]{String.valueOf(this.selectedTab.getRemainingPoints())});
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)remainingPoints, (float)(x + 240 - this.field_230712_o_.func_238414_a_((ITextProperties)remainingPoints)), (float)(y + 6), 0x404040);
        }
        this.field_230712_o_.func_243248_b(stack, TITLE, (float)(x + 8), (float)(y + 6), 0x404040);
    }

    public void renderTooltip(MatrixStack stack, int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.field_230706_i_.field_71439_g.func_70660_b((Effect)ModEffects.OBLIVION.get()) != null) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            stack.func_227860_a_();
            RenderSystem.enableDepthTest();
            stack.func_227861_a_((double)(guiLeft + 9), (double)(guiTop + 18), 400.0);
            this.selectedTab.drawTooltips(stack, mouseX - guiLeft - 9, mouseY - guiTop - 18);
            RenderSystem.disableDepthTest();
            stack.func_227865_b_();
        }
        if (this.tabs.size() > 1) {
            for (SkillsTabScreen tabScreen : this.tabs) {
                if (tabScreen != this.selectedTab || !tabScreen.isMouseOver(guiLeft, guiTop, mouseX, mouseY)) continue;
                this.func_238654_b_(stack, tabScreen.getTitle(), mouseX, mouseY);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrolling = false;
        }
        if (button == 0) {
            this.clicked = true;
            this.mousePos = new Vector3d(mouseX, mouseY, 0.0);
            for (SkillsTabScreen tab : this.tabs) {
                if (tab == this.selectedTab || !tab.isMouseOver(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
                this.selectedTab = tab;
                break;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.selectedTab != null && this.field_230706_i_.field_71439_g.func_70660_b((Effect)ModEffects.OBLIVION.get()) == null) {
            return this.selectedTab.mouseScrolled(mouseX, mouseY, amount);
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        block2: {
            block3: {
                block4: {
                    if (button != 0) break block2;
                    if (!this.clicked) break block3;
                    if (!this.scrolling) break block4;
                    if (this.mousePos == null) break block3;
                    Vector3d vector3d = new Vector3d(mouseX, mouseY, 0.0);
                    if (!(this.mousePos.func_72438_d(vector3d) < 5.0)) break block3;
                }
                this.unlockSkill(mouseX, mouseY);
            }
            this.clicked = false;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.scrolling = true;
        if (this.selectedTab != null && this.field_230706_i_.field_71439_g.func_70660_b((Effect)ModEffects.OBLIVION.get()) == null) {
            this.selectedTab.mouseDragged(mouseX, mouseY, mouseButton, xDragged, yDragged);
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, xDragged, yDragged);
    }

    private void unlockSkill(double mouseX, double mouseY) {
        ISkill selected;
        ISkill iSkill = selected = this.selectedTab != null ? this.selectedTab.getSelected(mouseX, mouseY, this.guiLeft, this.guiTop) : null;
        if (selected != null) {
            if (this.canUnlockSkill(selected)) {
                VampirismMod.dispatcher.sendToServer(new CUnlockSkillPacket(selected.getRegistryName()));
                this.playSoundEffect(SoundEvents.field_187802_ec, 0.7f);
            } else {
                this.playSoundEffect(SoundEvents.field_187679_dF, 0.5f);
            }
        }
    }

    private boolean canUnlockSkill(ISkill skill) {
        if (this.factionPlayer == null) {
            return false;
        }
        return this.factionPlayer.getSkillHandler().canSkillBeEnabled(skill) == ISkillHandler.Result.OK;
    }

    private void playSoundEffect(SoundEvent event, float pitch) {
        this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)1.0f));
    }
}

