/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.skills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.gui.skills.SkillNodeScreen;
import de.teamlapen.vampirism.client.gui.skills.SkillsScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.skills.SkillNode;
import de.teamlapen.vampirism.player.skills.SkillTree;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.advancements.AdvancementTabType;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
@ParametersAreNonnullByDefault
public class SkillsTabScreen
extends AbstractGui {
    public static final int SCREEN_WIDTH = 234;
    public static final int SCREEN_HEIGHT = 172;
    private final Minecraft minecraft;
    private final SkillsScreen screen;
    private final ISkillHandler<?> skillHandler;
    private final ItemStack icon;
    private final Map<SkillNode, SkillNodeScreen> nodes = new HashMap<SkillNode, SkillNodeScreen>();
    private final AdvancementTabType position;
    private final SkillNodeScreen root;
    private final int treeWidth;
    private final int treeHeight;
    private final ResourceLocation background;
    private boolean centered;
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MIN_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int maxX = Integer.MAX_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private float zoom = 1.0f;
    private final int index;
    private float fade;

    public SkillsTabScreen(Minecraft minecraft, SkillsScreen screen, int index, ItemStack icon, SkillNode rootNode, ISkillHandler<?> skillHandler) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.skillHandler = skillHandler;
        this.index = index;
        this.icon = icon;
        this.position = AdvancementTabType.LEFT;
        this.root = new SkillNodeScreen(minecraft, screen, this, rootNode, (SkillHandler)skillHandler);
        this.treeWidth = SkillTree.getTreeWidth(rootNode);
        this.treeHeight = SkillTree.getTreeHeight(rootNode);
        this.background = new ResourceLocation("vampirism", "textures/gui/skills/backgrounds/level.png");
        this.addNode(this.root);
        this.recalculateBorders();
        this.scrollX = 104.0;
        this.scrollY = 20.0;
    }

    private void recalculateBorders() {
        this.maxY = 20;
        this.minY = (int)((float)(-(this.treeHeight - 40)) * this.zoom);
        this.minX = 0;
        this.maxX = this.treeWidth;
        this.centered = false;
    }

    private void addNode(SkillNodeScreen screen) {
        this.nodes.put(screen.getSkillNode(), screen);
        for (SkillNodeScreen child : screen.getChildren()) {
            this.addNode(child);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void drawTab(MatrixStack stack, int x, int y, boolean selected) {
        this.position.func_238686_a_(stack, (AbstractGui)this, x, y, selected, this.index);
    }

    public void drawIcon(int x, int y, ItemRenderer itemRenderer) {
        this.position.func_192652_a(x, y, this.index, itemRenderer, this.icon);
    }

    public boolean isMouseOver(int guiLeft, int guiTop, double mouseX, double mouseY) {
        return this.position.func_198891_a(guiLeft, guiTop, this.index, mouseX, mouseY);
    }

    public void drawContents(MatrixStack stack) {
        if (!this.centered) {
            this.scrollX = MathHelper.func_151237_a((double)this.scrollX, (double)this.minX, (double)this.maxX);
            this.scrollY = MathHelper.func_151237_a((double)this.scrollY, (double)this.minY, (double)this.maxY);
            this.centered = true;
        }
        stack.func_227860_a_();
        RenderSystem.enableDepthTest();
        stack.func_227861_a_(0.0, 0.0, 950.0);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        SkillsTabScreen.func_238467_a_((MatrixStack)stack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        stack.func_227861_a_(0.0, 0.0, -950.0);
        RenderSystem.depthFunc((int)518);
        SkillsTabScreen.func_238467_a_((MatrixStack)stack, (int)234, (int)172, (int)0, (int)0, (int)-16777216);
        RenderSystem.depthFunc((int)515);
        this.minecraft.func_110434_K().func_110577_a(this.background);
        int i = MathHelper.func_76128_c((double)this.scrollX);
        int j = MathHelper.func_76128_c((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        stack.func_227862_a_(this.zoom, this.zoom, 1.0f);
        int i1 = -1;
        while ((float)i1 <= 15.0f / this.zoom) {
            int j1 = -1;
            while ((float)j1 <= 12.0f / this.zoom) {
                SkillsTabScreen.func_238463_a_((MatrixStack)stack, (int)(k + 16 * i1), (int)(l + 16 * j1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                ++j1;
            }
            ++i1;
        }
        this.root.drawConnectivity(stack, i, j, true);
        this.root.drawConnectivity(stack, i, j, false);
        this.root.draw(stack, i, j);
        RenderSystem.depthFunc((int)518);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        SkillsTabScreen.func_238467_a_((MatrixStack)stack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.depthFunc((int)515);
        stack.func_227865_b_();
        if (this.minecraft.field_71439_g.func_70660_b((Effect)ModEffects.OBLIVION.get()) != null) {
            stack.func_227860_a_();
            RenderSystem.enableDepthTest();
            stack.func_227861_a_(0.0, 0.0, 200.0);
            SkillsTabScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)234, (int)172, (int)(MathHelper.func_76128_c((double)127.5) << 24));
            RenderSystem.disableDepthTest();
            stack.func_227865_b_();
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 200.0);
            this.drawDisableText(stack);
            stack.func_227865_b_();
        }
    }

    public void drawTooltips(MatrixStack stack, int mouseX, int mouseY) {
        RenderSystem.pushMatrix();
        stack.func_227861_a_(0.0, 0.0, 200.0);
        SkillsTabScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)234, (int)172, (int)(MathHelper.func_76141_d((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        int scrollX = MathHelper.func_76128_c((double)this.scrollX);
        int scrollY = MathHelper.func_76128_c((double)this.scrollY);
        if (mouseX >= 0 && mouseX < 235 && mouseY >= 0 && mouseY < 173) {
            for (SkillNodeScreen nodeScreen : this.nodes.values()) {
                if (!nodeScreen.isMouseOver((float)mouseX / this.zoom, (float)mouseY / this.zoom, scrollX, scrollY)) continue;
                flag = true;
                stack.func_227860_a_();
                stack.func_227862_a_(this.zoom, this.zoom, 1.0f);
                nodeScreen.drawHover(stack, (float)mouseX / this.zoom, (float)mouseY / this.zoom, this.fade, scrollX, scrollY);
                stack.func_227865_b_();
                break;
            }
        }
        RenderSystem.popMatrix();
        this.fade = flag ? MathHelper.func_76131_a((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : MathHelper.func_76131_a((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public void mouseDragged(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.scrollX += xDragged / (double)this.zoom;
        this.scrollY += yDragged / (double)this.zoom;
        this.centered = false;
    }

    public List<? extends IReorderingProcessor> getTitle() {
        return Collections.emptyList();
    }

    @Nullable
    public ISkill getSelected(double mouseX, double mouseY, int guiLeft, int guiTop) {
        int i = MathHelper.func_76128_c((double)this.scrollX);
        int j = MathHelper.func_76128_c((double)this.scrollY);
        for (SkillNodeScreen screen : this.nodes.values()) {
            ISkill selected = screen.getSelectedSkill((mouseX - (double)guiLeft - 9.0) / (double)this.zoom, (mouseY - (double)guiTop - 18.0) / (double)this.zoom, i, j);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public int getRemainingPoints() {
        return this.skillHandler.getLeftSkillPoints();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        double scrollXP = this.scrollX * (double)this.zoom;
        double scrollYP = this.scrollY * (double)this.zoom;
        float heightZoom = this.zoom = (float)((double)this.zoom + amount / 25.0);
        float widthZoom = this.zoom;
        if (this.zoom * (float)this.treeHeight < 172.0f) {
            heightZoom = Math.max(this.zoom, 172.0f / (float)this.treeHeight);
        }
        if (this.zoom * (float)this.treeWidth < 214.0f) {
            widthZoom = Math.max(this.zoom, 214.0f / (float)Math.max(60, this.treeWidth));
        }
        this.zoom = Math.min(heightZoom, widthZoom);
        this.zoom = Math.min(1.0f, this.zoom);
        this.scrollX = scrollXP / (double)this.zoom;
        this.scrollY = scrollYP / (double)this.zoom;
        this.recalculateBorders();
        return true;
    }

    public void drawDisableText(MatrixStack mStack) {
        if (this.minecraft.field_71439_g.func_70660_b((Effect)ModEffects.OBLIVION.get()) == null) {
            return;
        }
        IFormattableTextComponent f = new TranslationTextComponent("text.vampirism.skill.unlock_unavailable").func_240699_a_(TextFormatting.WHITE);
        IReorderingProcessor s = LanguageMap.func_74808_a().func_241870_a((ITextProperties)f);
        int tooltipTextWidth = 219;
        int tooltipX = 7;
        int tooltipY = 17;
        this.minecraft.field_71466_p.getClass();
        int tooltipHeight = 9 * 2;
        int backgroundColor = -258276348;
        int borderColorStart = 1348406284;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        int zLevel = this.func_230927_p_();
        mStack.func_227860_a_();
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        mStack.func_227861_a_(0.0, 0.0, (double)zLevel);
        this.minecraft.field_71466_p.func_238416_a_(s, (float)tooltipX + (float)tooltipTextWidth / 2.0f - (float)this.minecraft.field_71466_p.func_238414_a_((ITextProperties)f) / 2.0f, (float)tooltipY + (float)tooltipHeight / 2.0f - 3.0f, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
        renderType.func_228461_a_();
        mStack.func_227865_b_();
    }
}

