/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.widget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWithDummyWidget;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.client.gui.ExtendedScreen;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.player.tasks.reward.ItemRewardInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TaskItem<T extends Screen>
extends ScrollableListWithDummyWidget.ListItem<ITaskInstance> {
    protected static final ResourceLocation TASKMASTER_GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/taskmaster.png");
    protected static final ITextComponent REWARD = new TranslationTextComponent("gui.vampirism.taskmaster.reward").func_240699_a_(TextFormatting.UNDERLINE);
    protected static final ITextComponent REQUIREMENT = new TranslationTextComponent("gui.vampirism.taskmaster.requirement").func_240699_a_(TextFormatting.UNDERLINE);
    protected static final ITextComponent REQUIREMENT_STRIKE = REQUIREMENT.func_230531_f_().func_240699_a_(TextFormatting.STRIKETHROUGH);
    protected static final ItemStack SKULL_ITEM = new ItemStack((IItemProvider)Blocks.field_196703_eM);
    protected static final ItemStack PAPER = new ItemStack((IItemProvider)Items.field_151121_aF);
    protected final T screen;
    protected final IFactionPlayer<?> factionPlayer;
    private final TaskActionButton taskButton;
    private final Map<ITaskInstance, List<ITextComponent>> toolTips = Maps.newHashMap();

    public TaskItem(ITaskInstance item, ScrollableListWithDummyWidget<ITaskInstance> list, boolean isDummy, T screen, IFactionPlayer<?> factionPlayer) {
        super(item, list, isDummy);
        this.screen = screen;
        this.factionPlayer = factionPlayer;
        this.taskButton = isDummy ? new TaskActionButton(0, 0) : null;
    }

    public List<ITextComponent> getTooltipFromItem2(ItemStack itemStack, boolean strikeThough, @Nullable String bonus) {
        List list = itemStack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                IFormattableTextComponent t = ((ITextComponent)list.get(0)).func_230532_e_().func_240702_b_(" " + (bonus != null ? bonus : "") + itemStack.func_190916_E());
                if (strikeThough) {
                    t.func_240699_a_(TextFormatting.STRIKETHROUGH);
                }
                list1.add(t);
                continue;
            }
            list1.add(strikeThough ? ((ITextComponent)list.get(i)).func_230532_e_().func_240699_a_(TextFormatting.STRIKETHROUGH) : (ITextComponent)list.get(i));
        }
        return list1;
    }

    @Override
    public boolean onDummyClick(double mouseX, double mouseY) {
        this.taskButton.func_230982_a_(mouseX, mouseY);
        return true;
    }

    @Override
    public void renderDummy(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
        RenderSystem.enableDepthTest();
        GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)TASKMASTER_GUI_TEXTURE, (int)x, (int)y, (int)17, (int)208, (int)listWidth, (int)itemHeight, (int)136, (int)21, (int)3, (int)3, (int)3, (int)3, (float)zLevel);
        RenderSystem.disableDepthTest();
        ITaskRewardInstance reward = ((ITaskInstance)this.item).getReward();
        if (reward instanceof ItemRewardInstance) {
            ItemStack stack = ((ItemRewardInstance)reward).getReward();
            ((ExtendedScreen)this.screen).getItemRenderer().func_180450_b(stack, x + 3 + 113 - 21, y + 2);
            ((ExtendedScreen)this.screen).getItemRenderer().func_180453_a(((Screen)this.screen).field_230712_o_, stack, x + 3 + 113 - 21, y + 2, "" + Math.min(stack.func_190916_E(), stack.func_77976_d()));
        } else {
            ((ExtendedScreen)this.screen).getItemRenderer().func_180450_b(PAPER, x + 3 + 113 - 21, y + 2);
        }
        List<TaskRequirement.Requirement<?>> requirements = ((ITaskInstance)this.item).getTask().getRequirement().getAll();
        block4: for (int i = 0; i < requirements.size(); ++i) {
            TaskRequirement.Requirement<?> requirement = requirements.get(i);
            switch (requirement.getType()) {
                case ITEMS: {
                    ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                    ((ExtendedScreen)this.screen).getItemRenderer().func_180450_b(stack, x + 3 + 3 + i * 20, y + 2);
                    ((ExtendedScreen)this.screen).getItemRenderer().func_180453_a(((Screen)this.screen).field_230712_o_, stack, x + 3 + 3 + i * 20, y + 2, "" + Math.min(stack.func_190916_E(), stack.func_77976_d()));
                    continue block4;
                }
                case ENTITY: 
                case ENTITY_TAG: {
                    ((ExtendedScreen)this.screen).getItemRenderer().func_180450_b(SKULL_ITEM, x + 3 + 3 + i * 20, y + 2);
                    ((ExtendedScreen)this.screen).getItemRenderer().func_180453_a(((Screen)this.screen).field_230712_o_, SKULL_ITEM, x + 3 + 3 + i * 20, y + 2, "" + requirement.getAmount(this.factionPlayer));
                    continue block4;
                }
                default: {
                    ((ExtendedScreen)this.screen).getItemRenderer().func_180450_b(PAPER, x + 3 + 3 + i * 20, y + 2);
                }
            }
        }
        this.taskButton.field_230690_l_ = x + listWidth - 17;
        this.taskButton.field_230691_m_ = y + 4;
        this.taskButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderDummyToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        if (mouseX >= x + 3 + 113 - 21 + 1 && mouseX < x + 3 + 113 - 21 + 16 + 1 && mouseY >= y + 2 && mouseY < y + 2 + 16) {
            ITaskRewardInstance reward = ((ITaskInstance)this.item).getReward();
            if (reward instanceof ItemRewardInstance) {
                this.renderItemTooltip(matrixStack, ((ItemRewardInstance)reward).getReward(), mouseX, mouseY, REWARD, false, null);
            } else {
                this.renderItemTooltip(matrixStack, ((ITaskInstance)this.item).getTask(), mouseX, mouseY);
            }
        }
        List<TaskRequirement.Requirement<?>> requirements = ((ITaskInstance)this.item).getTask().getRequirement().getAll();
        for (int i = 0; i < requirements.size(); ++i) {
            if (mouseX < x + 3 + 3 + i * 20 || mouseX >= x + 3 + 16 + 3 + i * 20 || mouseY < y + 2 || mouseY >= y + 2 + 16) continue;
            this.renderRequirementTool(matrixStack, (ITaskInstance)this.item, requirements.get(i), mouseX, mouseY);
        }
        this.taskButton.func_230443_a_(matrixStack, mouseX, mouseY);
    }

    @Override
    public void renderItem(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
        RenderSystem.enableDepthTest();
        this.colorTask();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TASKMASTER_GUI_TEXTURE);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)this.screen.func_230927_p_(), (float)17.0f, (float)187.0f, (int)136, (int)21, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)(x + 132), (int)y, (int)this.screen.func_230927_p_(), (float)150.0f, (float)187.0f, (int)3, (int)21, (int)256, (int)256);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Optional text = Optional.ofNullable(((Screen)this.screen).field_230712_o_.func_238425_b_((ITextProperties)((ITaskInstance)this.item).getTask().getTranslation(), 131).get(0));
        text.ifPresent(t -> ((Screen)this.screen).field_230712_o_.func_238422_b_(matrixStack, t, (float)(x + 2), (float)(y + 4), 3419941));
        if (!((ExtendedScreen)this.screen).getTaskContainer().isTaskNotAccepted((ITaskInstance)this.item) && !((ITaskInstance)this.item).isUnique()) {
            TranslationTextComponent msg;
            long remainingTime = ((ITaskInstance)this.item).getTaskTimeStamp() - Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if (remainingTime >= 0L) {
                long hours = (remainingTime /= 20L) / 60L / 60L;
                long minutes = remainingTime / 60L % 60L;
                long seconds = remainingTime % 60L;
                String time = "" + hours + ":";
                if (minutes < 10L) {
                    time = time + "0";
                }
                time = time + minutes + ":";
                if (seconds < 10L) {
                    time = time + "0";
                }
                time = time + seconds;
                msg = new StringTextComponent(time);
            } else {
                msg = new TranslationTextComponent("text.vampirism.task_failed");
            }
            int width = ((Screen)this.screen).field_230712_o_.func_238414_a_((ITextProperties)msg);
            int color = 0xAAAAAA;
            if ((double)remainingTime < (double)(((ITaskInstance)this.item).getTaskDuration() / 20L) * 0.1) {
                color = 0xFF5555;
            }
            ((Screen)this.screen).field_230712_o_.func_243246_a(matrixStack, (ITextComponent)msg, (float)(x + 134 - width), (float)(y + 12), color);
        }
        RenderSystem.disableDepthTest();
    }

    @Override
    public void renderItemToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        List<ITextComponent> toolTips = this.toolTips.getOrDefault(this.item, Lists.newArrayList());
        if (toolTips.isEmpty()) {
            this.generateTaskToolTip((ITaskInstance)this.item, toolTips);
        }
        this.screen.func_243308_b(matrixStack, toolTips, mouseX, mouseY);
    }

    private void clickButton(Button id) {
        ((ExtendedScreen)this.screen).getTaskContainer().pressButton((ITaskInstance)this.item);
    }

    private void colorTask() {
        TaskContainer container = ((ExtendedScreen)this.screen).getTaskContainer();
        if (container.isCompleted((ITaskInstance)this.item)) {
            RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        } else {
            boolean remainsTime;
            boolean isUnique = ((ITaskInstance)this.item).isUnique();
            boolean bl = remainsTime = ((ITaskInstance)this.item).getTaskTimeStamp() - Minecraft.func_71410_x().field_71441_e.func_82737_E() > 0L;
            if (container.canCompleteTask((ITaskInstance)this.item)) {
                if (isUnique) {
                    RenderSystem.color4f((float)1.0f, (float)0.8558594f, (float)0.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.0f, (float)0.9f, (float)0.0f, (float)1.0f);
                }
            } else if (container.isTaskNotAccepted((ITaskInstance)this.item)) {
                if (isUnique) {
                    RenderSystem.color4f((float)0.64f, (float)0.57f, (float)0.5f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.55f, (float)0.55f, (float)0.55f, (float)1.0f);
                }
            } else if (!isUnique && !remainsTime) {
                RenderSystem.color4f((float)1.0f, (float)0.33333334f, (float)0.33333334f, (float)1.0f);
            } else if (isUnique) {
                RenderSystem.color4f((float)1.0f, (float)0.9f, (float)0.6f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.85f, (float)1.0f, (float)0.85f, (float)1.0f);
            }
        }
    }

    private void generateTaskToolTip(ITaskInstance taskInfo, List<ITextComponent> toolTips) {
        Task task = taskInfo.getTask();
        toolTips.clear();
        toolTips.add((ITextComponent)task.getTranslation().func_230531_f_().func_240699_a_(((ExtendedScreen)this.screen).getTaskContainer().getFactionColor()));
        if (task.useDescription()) {
            toolTips.add(task.getDescription());
            toolTips.add((ITextComponent)new StringTextComponent(" "));
        }
        if (((ExtendedScreen)this.screen).getTaskContainer().isTaskNotAccepted(taskInfo)) {
            toolTips.add((ITextComponent)new TranslationTextComponent("gui.vampirism.taskmaster.not_accepted"));
        } else {
            for (List<TaskRequirement.Requirement<?>> requirements : task.getRequirement().requirements().values()) {
                if (requirements == null) continue;
                TaskRequirement.Type type = requirements.get(0).getType();
                boolean completed = ((ExtendedScreen)this.screen).getTaskContainer().areRequirementsCompleted(taskInfo, type);
                IFormattableTextComponent title = new TranslationTextComponent(type.getTranslationKey()).func_240702_b_(":");
                if (completed) {
                    title.func_240699_a_(TextFormatting.STRIKETHROUGH);
                }
                toolTips.add((ITextComponent)title);
                for (TaskRequirement.Requirement<?> requirement : requirements) {
                    TranslationTextComponent desc;
                    int completedAmount = ((ExtendedScreen)this.screen).getTaskContainer().getRequirementStatus(taskInfo, requirement);
                    switch (type) {
                        case ITEMS: {
                            desc = ((Item)requirement.getStat(this.factionPlayer)).func_200296_o().func_230531_f_().func_240702_b_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case STATS: {
                            desc = new TranslationTextComponent("stat." + requirement.getStat(this.factionPlayer).toString().replace(':', '.')).func_240702_b_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case ENTITY: {
                            desc = ((EntityType)requirement.getStat(this.factionPlayer)).func_212546_e().func_230531_f_().func_240702_b_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case ENTITY_TAG: {
                            desc = new TranslationTextComponent("tasks.vampirism." + ((ITag.INamedTag)requirement.getStat(this.factionPlayer)).func_230234_a_()).func_240702_b_(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        default: {
                            desc = new TranslationTextComponent(task.getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.'));
                        }
                    }
                    if (completed || ((ExtendedScreen)this.screen).getTaskContainer().isRequirementCompleted(taskInfo, requirement)) {
                        desc.func_240699_a_(TextFormatting.STRIKETHROUGH);
                    }
                    toolTips.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)desc));
                }
            }
        }
        this.toolTips.put(taskInfo, toolTips);
    }

    private void renderDefaultRequirementToolTip(MatrixStack mStack, ITaskInstance task, TaskRequirement.Requirement<?> requirement, int x, int y, boolean strikeThrough) {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
        TranslationTextComponent text = new TranslationTextComponent(task.getTask().getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.'));
        if (strikeThrough) {
            text.func_240699_a_(TextFormatting.STRIKETHROUGH);
        }
        tooltips.add(text);
        this.screen.func_243308_b(mStack, (List)tooltips, x, y);
    }

    private void renderGenericRequirementTooltip(MatrixStack mStack, TaskRequirement.Type type, int x, int y, IFormattableTextComponent text, boolean strikeThrough) {
        ArrayList tooltips = Lists.newArrayList();
        IFormattableTextComponent title = new TranslationTextComponent(type.getTranslationKey()).func_240702_b_(":");
        if (strikeThrough) {
            text.func_240699_a_(TextFormatting.STRIKETHROUGH);
            title.func_240699_a_(TextFormatting.STRIKETHROUGH);
        }
        tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
        tooltips.add(title.func_240699_a_(TextFormatting.ITALIC));
        tooltips.add(new StringTextComponent("  ").func_230529_a_((ITextComponent)text));
        this.screen.renderWrappedToolTip(mStack, (List)tooltips, x, y, ((Screen)this.screen).field_230712_o_);
    }

    private void renderItemTooltip(MatrixStack mStack, ItemStack stack, int x, int y, ITextComponent text, boolean strikeThrough, @Nullable String bonus) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List<ITextComponent> tooltips = this.getTooltipFromItem2(stack, strikeThrough, bonus);
        tooltips.add(0, text);
        this.screen.renderWrappedToolTip(mStack, tooltips, x, y, font == null ? ((Screen)this.screen).field_230712_o_ : font);
        GuiUtils.postItemToolTip();
    }

    private void renderItemTooltip(MatrixStack mStack, Task task, int x, int y) {
        ArrayList tooltips = Lists.newArrayList((Object[])new ITextComponent[]{REWARD});
        tooltips.add(new TranslationTextComponent(task.getTranslationKey() + ".reward"));
        this.screen.func_243308_b(mStack, (List)tooltips, x, y);
    }

    private void renderRequirementTool(MatrixStack mStack, ITaskInstance task, TaskRequirement.Requirement<?> requirement, int x, int y) {
        boolean notAccepted = ((ExtendedScreen)this.screen).getTaskContainer().isTaskNotAccepted((ITaskInstance)this.item);
        boolean completed = ((ExtendedScreen)this.screen).getTaskContainer().isRequirementCompleted((ITaskInstance)this.item, requirement);
        int completedAmount = ((ExtendedScreen)this.screen).getTaskContainer().getRequirementStatus((ITaskInstance)this.item, requirement);
        switch (requirement.getType()) {
            case ITEMS: {
                this.renderItemTooltip(mStack, ((ItemRequirement)requirement).getItemStack(), x, y, completed ? REQUIREMENT_STRIKE : REQUIREMENT, completed, notAccepted ? null : completedAmount + "/");
                break;
            }
            case ENTITY: {
                this.renderGenericRequirementTooltip(mStack, TaskRequirement.Type.ENTITY, x, y, ((EntityType)requirement.getStat(this.factionPlayer)).func_212546_e().func_230531_f_().func_240702_b_((notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            case ENTITY_TAG: {
                this.renderGenericRequirementTooltip(mStack, TaskRequirement.Type.ENTITY_TAG, x, y, new TranslationTextComponent("tasks.vampirism." + ((ITag.INamedTag)requirement.getStat(this.factionPlayer)).func_230234_a_()).func_240702_b_((notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            case STATS: {
                this.renderGenericRequirementTooltip(mStack, TaskRequirement.Type.STATS, x, y, new TranslationTextComponent("stat." + requirement.getStat(this.factionPlayer).toString().replace(':', '.')).func_240702_b_((notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            default: {
                this.renderDefaultRequirementToolTip(mStack, task, requirement, x, y, completed);
            }
        }
    }

    private class TaskActionButton
    extends ImageButton {
        public TaskActionButton(int xPos, int yPos) {
            super(xPos, yPos, 14, 13, 0, 0, 0, TASKMASTER_GUI_TEXTURE, 0, 0, x$0 -> TaskItem.this.clickButton(x$0), (ITextComponent)new StringTextComponent(""));
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            if (mouseX > (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY > (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_)) {
                super.func_230982_a_(mouseX, mouseY);
            }
        }

        public void func_230431_b_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float p_renderButton_3_) {
            int j;
            TaskContainer.TaskAction action = ((ExtendedScreen)TaskItem.this.screen).getTaskContainer().buttonAction((ITaskInstance)TaskItem.this.item);
            RenderSystem.enableDepthTest();
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(TASKMASTER_GUI_TEXTURE);
            switch (action) {
                case ACCEPT: {
                    j = 190;
                    break;
                }
                case COMPLETE: {
                    j = 176;
                    break;
                }
                default: {
                    j = 204;
                }
            }
            TaskActionButton.func_238463_a_((MatrixStack)mStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)j, (float)(this.field_230692_n_ ? 13 : 0), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)256, (int)256);
            RenderSystem.disableDepthTest();
        }

        public void func_230443_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY) {
            if (this.field_230692_n_ && this.field_230694_p_) {
                TaskContainer.TaskAction action = ((ExtendedScreen)TaskItem.this.screen).getTaskContainer().buttonAction((ITaskInstance)TaskItem.this.item);
                TaskItem.this.screen.func_238652_a_(mStack, (ITextComponent)new TranslationTextComponent(action.getTranslationKey()), mouseX, mouseY);
            }
        }
    }
}

