/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VillagerWithArmsModel<T extends MobEntity>
extends VillagerModel<T>
implements IHasArm {
    private final ModelRenderer leftArm;
    private final ModelRenderer rightArm;

    public VillagerWithArmsModel(float scale) {
        this(scale, 0.0f, 64, 64);
    }

    public VillagerWithArmsModel(float scale, float p_i1164_2_, int width, int height) {
        super(scale, width, height);
        this.field_78190_c.field_78806_j = false;
        this.rightArm = new ModelRenderer((Model)this).func_78787_b(width, height);
        this.rightArm.func_78784_a(44, 22).func_228301_a_(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, scale);
        this.rightArm.func_78793_a(0.0f, 2.0f + p_i1164_2_, 0.0f);
        this.rightArm.func_228300_a_(-4.0f, 6.0f, -2.0f, 4.0f, 3.0f, 4.0f);
        this.leftArm = new ModelRenderer((Model)this).func_78787_b(width, height);
        this.leftArm.func_78784_a(44, 22).func_228301_a_(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, scale);
        this.leftArm.func_228301_a_(0.0f, 6.0f, -2.0f, 4.0f, 3.0f, 4.0f, scale);
        this.leftArm.func_78793_a(-5.0f, 2.0f + p_i1164_2_, 0.0f);
        this.leftArm.field_78809_i = true;
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return Iterables.concat((Iterable)super.func_225601_a_(), (Iterable)ImmutableList.of((Object)this.leftArm, (Object)this.rightArm));
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.func_78793_a(4.0f, 3.0f, -1.0f);
        this.rightArm.func_78793_a(-4.0f, 3.0f, -1.0f);
        this.leftArm.field_78795_f = -0.75f;
        this.rightArm.field_78795_f = -0.75f;
        if (this.field_217112_c > 0.0f) {
            HandSide enumhandside = this.getMainHand((Entity)entityIn);
            ModelRenderer modelrenderer = this.getArmForSide(enumhandside);
            float f1 = 1.0f - this.field_217112_c;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.field_78191_a.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f2 * 1.2 + (double)f3));
        }
    }

    public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
        float f = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        ModelRenderer arm = this.getArmForSide(handSide);
        arm.field_78800_c += f;
        arm.func_228307_a_(matrixStack);
        arm.field_78800_c -= f;
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.leftArm : this.rightArm;
    }

    protected HandSide getMainHand(Entity entityIn) {
        return entityIn instanceof LivingEntity ? ((LivingEntity)entityIn).func_184591_cq() : HandSide.RIGHT;
    }
}

