/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.items.CrucifixItem;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.MixinHooks;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RenderHandler
implements ISelectiveResourceReloadListener {
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @Nonnull
    private final Minecraft mc;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int VAMPIRE_BIOME_FADE_TICKS = 60;
    private final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private OutlineLayerBuffer bloodVisionBuffer;
    private BatEntity entityBat;
    private int vampireBiomeTicks = 0;
    private boolean insideFog = false;
    private int bloodVisionTicks = 0;
    private int lastBloodVisionTicks = 0;
    private float vampireBiomeFogDistanceMultiplier = 1.0f;
    @Nullable
    private ShaderGroup blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean reducedBloodVision = false;
    @Nullable
    private Shader blur1;
    @Nullable
    private Shader blur2;
    @Nullable
    private Shader blit0;
    private boolean isInsideBloodVisionRendering = false;

    public RenderHandler(@Nonnull Minecraft mc) {
        this.mc = mc;
    }

    @Nullable
    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (this.shouldRenderBloodVision()) {
            this.reducedBloodVision = OptifineHandler.isShaders();
            if (!this.reducedBloodVision) {
                if (this.displayHeight != this.mc.func_228018_at_().func_198091_l() || this.displayWidth != this.mc.func_228018_at_().func_198109_k()) {
                    this.displayHeight = this.mc.func_228018_at_().func_198091_l();
                    this.displayWidth = this.mc.func_228018_at_().func_198109_k();
                    this.updateFramebufferSize(this.displayWidth, this.displayHeight);
                }
                this.adjustBloodVisionShaders(this.getBloodVisionProgress((float)event.getRenderPartialTicks()));
            } else {
                MixinHooks.enforcingGlowing_bloodVision = true;
            }
        }
        if (((Boolean)VampirismConfig.SERVER.preventRenderingDebugBoundingBoxes.get()).booleanValue()) {
            Minecraft.func_71410_x().func_175598_ae().func_178629_b(false);
        }
        if (event.getInfo().func_216773_g() instanceof LivingEntity && ((LivingEntity)event.getInfo().func_216773_g()).func_70608_bn()) {
            ((LivingEntity)event.getInfo().func_216773_g()).func_213374_dv().map(pos -> event.getInfo().func_216773_g().field_70170_p.func_180495_p(pos)).filter(blockState -> blockState.func_177230_c() instanceof CoffinBlock).ifPresent(blockState -> {
                if (((Boolean)blockState.func_177229_b((Property)CoffinBlock.VERTICAL)).booleanValue()) {
                    event.getInfo().func_216782_a(0.2, -0.2, 0.0);
                } else {
                    event.getInfo().func_216782_a(0.0, -0.2, 0.0);
                }
            });
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.lastBloodVisionTicks = this.bloodVisionTicks;
        VampirePlayer vampire = VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).resolve().orElse(null);
        if (vampire != null) {
            if (vampire.getSpecialAttributes().blood_vision && !((Boolean)VampirismConfig.CLIENT.disableBloodVisionRendering.get()).booleanValue() && !vampire.isGettingSundamage((IWorld)this.mc.field_71439_g.field_70170_p)) {
                if (this.bloodVisionTicks < 80) {
                    ++this.bloodVisionTicks;
                }
            } else {
                if (this.bloodVisionTicks > 0) {
                    this.bloodVisionTicks -= 2;
                }
                if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                    this.bloodVisionTicks = 0;
                }
            }
        }
        if (this.mc.field_71439_g.field_70173_aa % 10 == 0) {
            if ((((Boolean)VampirismConfig.CLIENT.renderVampireForestFog.get()).booleanValue() || ((Boolean)VampirismConfig.SERVER.enforceRenderForestFog.get()).booleanValue()) && (Helper.isEntityInArtificalVampireFogArea((Entity)this.mc.field_71439_g) || Helper.isEntityInVampireBiome((Entity)this.mc.field_71439_g))) {
                this.insideFog = true;
                this.vampireBiomeFogDistanceMultiplier = vampire != null && vampire.getLevel() > 0 ? 2.0f : 1.0f;
                this.vampireBiomeFogDistanceMultiplier = (float)((double)this.vampireBiomeFogDistanceMultiplier + (vampire != null && vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.VISTA.get()) ? (Double)VampirismConfig.BALANCE.vrVistaMod.get() : 0.0));
            } else {
                this.insideFog = false;
            }
        }
        if (this.insideFog) {
            if (this.vampireBiomeTicks < 60) {
                ++this.vampireBiomeTicks;
            }
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (this.vampireBiomeTicks == 0) {
            return;
        }
        float f = 60.0f / (float)this.vampireBiomeTicks / 1.5f;
        float fogStart = Math.min(event.getFarPlaneDistance() * 0.75f, 6.0f * (f *= this.vampireBiomeFogDistanceMultiplier));
        float fogEnd = Math.min(event.getFarPlaneDistance(), 50.0f * f);
        RenderSystem.fogStart((float)(event.getType() == FogRenderer.FogType.FOG_SKY ? 0.0f : fogStart));
        RenderSystem.fogEnd((float)fogEnd);
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S() && VampirismPlayerAttributes.get((PlayerEntity)this.mc.field_71439_g).getVampSpecial().bat) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (!this.isInsideBloodVisionRendering && this.shouldRenderBloodVision() && !this.reducedBloodVision) {
            LivingEntity entity = event.getEntity();
            boolean flag = !(entity instanceof PlayerEntity) || VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)entity)).getHuntSpecial().fullHunterCoat == null;
            double dist = this.mc.field_71439_g.func_70068_e((Entity)entity);
            if (dist > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistanceSq.get()).intValue()) {
                flag = false;
            }
            if (flag) {
                LazyOptional<IExtendedCreatureVampirism> opt;
                LazyOptional<IExtendedCreatureVampirism> lazyOptional = opt = entity instanceof CreatureEntity && entity.func_70089_S() ? ExtendedCreature.getSafe((Entity)entity) : LazyOptional.empty();
                int color = opt.map(creature -> creature.getBlood() > 0 && !creature.hasPoisonousBlood()).orElse(false) != false ? 0xFF0000 : (VampirismPlayerAttributes.get((PlayerEntity)this.mc.field_71439_g).getVampSpecial().blood_vision_garlic && (opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) != false || entity instanceof IHunterMob) ? 524039 : 0xA0A0A0);
                EntityRendererManager renderManager = this.mc.func_175598_ae();
                if (this.bloodVisionBuffer == null) {
                    this.bloodVisionBuffer = new OutlineLayerBuffer(this.mc.func_228019_au_().func_228487_b_());
                }
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getBloodVisionProgress(event.getPartialRenderTick()));
                this.bloodVisionBuffer.func_228472_a_(r, g, b, alpha);
                float f = MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)entity.field_70126_B, (float)entity.field_70177_z);
                this.isInsideBloodVisionRendering = true;
                EntityRenderer entityrenderer = renderManager.func_78713_a((Entity)entity);
                entityrenderer.func_225623_a_((Entity)entity, f, event.getPartialRenderTick(), event.getMatrixStack(), (IRenderTypeBuffer)this.bloodVisionBuffer, renderManager.func_229085_a_((Entity)entity, event.getPartialRenderTick()));
                this.mc.func_147110_a().func_147610_a(false);
                this.isInsideBloodVisionRendering = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre<PlayerEntity, PlayerModel<PlayerEntity>> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof PlayerEntity && VampirismPlayerAttributes.get((PlayerEntity)entity).getHuntSpecial().isDisguised()) {
            IItemWithTier.TIER hunterCoatTier;
            double dist;
            double d = dist = this.mc.field_71439_g == null ? 0.0 : entity.func_70068_e((Entity)this.mc.field_71439_g);
            if (dist > 64.0) {
                event.setCanceled(true);
            } else if (dist > 16.0 && ((hunterCoatTier = VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)entity)).getHuntSpecial().fullHunterCoat) == IItemWithTier.TIER.ENHANCED || hunterCoatTier == IItemWithTier.TIER.ULTIMATE)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderFirstPersonHand(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && event.getHand() == Hand.MAIN_HAND && player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184614_ca().func_77973_b() instanceof CrucifixItem) {
            int i = player.func_184591_cq() == HandSide.RIGHT ? 1 : -1;
            event.getMatrixStack().func_227861_a_((double)((float)(-i) * 0.56f), -0.0, (double)-0.2f);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        VampirePlayerSpecialAttributes vAtt = VampirismPlayerAttributes.get(player).getVampSpecial();
        if (vAtt.isDBNO) {
            event.getMatrixStack().func_227861_a_(1.2, 0.0, 0.0);
            PlayerModel m = (PlayerModel)event.getRenderer().func_217764_d();
            m.field_178723_h.field_78806_j = false;
            m.field_178732_b.field_78806_j = false;
            m.field_178724_i.field_78806_j = false;
            m.field_178734_a.field_78806_j = false;
            m.field_178721_j.field_78806_j = false;
            m.field_178722_k.field_78806_j = false;
            m.field_178731_d.field_78806_j = false;
            m.field_178733_c.field_78806_j = false;
        } else if (player.func_213374_dv().map(pos -> player.field_70170_p.func_180495_p(pos)).map(state -> state.func_177230_c() instanceof CoffinBlock).orElse(false).booleanValue()) {
            event.getMatrixStack().func_227862_a_(0.8f, 0.95f, 0.8f);
        } else if (event.getPlayer().func_184587_cr() && event.getPlayer().func_184605_cv() > 0 && event.getPlayer().func_184614_ca().func_77973_b() instanceof CrucifixItem) {
            if (event.getPlayer().func_184591_cq() == HandSide.RIGHT) {
                ((PlayerModel)event.getRenderer().func_217764_d()).field_187076_m = BipedModel.ArmPose.BLOCK;
            } else {
                ((PlayerModel)event.getRenderer().func_217764_d()).field_187075_l = BipedModel.ArmPose.BLOCK;
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        MixinHooks.enforcingGlowing_bloodVision = false;
        if (this.mc.field_71441_e == null) {
            return;
        }
        float partialTicks = this.mc.func_184121_ak();
        if (this.shouldRenderBloodVision() && !this.reducedBloodVision) {
            this.blurShader.func_148018_a(partialTicks);
            if (this.bloodVisionBuffer != null) {
                this.bloodVisionBuffer.func_228471_a_();
            }
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.reMakeBloodVisionShader();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.bloodVisionTicks = 0;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderPlayerPreHigh(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        VampirePlayerSpecialAttributes vAtt = VampirismPlayerAttributes.get(player).getVampSpecial();
        if (vAtt.invisible) {
            event.setCanceled(true);
        } else if (vAtt.bat) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = (BatEntity)EntityType.field_200791_e.func_200721_a(event.getEntity().func_130014_f_());
                this.entityBat.func_82236_f(false);
            }
            float partialTicks = event.getPartialRenderTick();
            this.entityBat.field_70760_ar = player.field_70760_ar;
            this.entityBat.field_70761_aq = player.field_70761_aq;
            this.entityBat.field_70173_aa = player.field_70173_aa;
            this.entityBat.field_70125_A = player.field_70125_A;
            this.entityBat.field_70177_z = player.field_70177_z;
            this.entityBat.field_70759_as = player.field_70759_as;
            this.entityBat.field_70126_B = player.field_70126_B;
            this.entityBat.field_70127_C = player.field_70127_C;
            this.entityBat.field_70758_at = player.field_70758_at;
            this.entityBat.func_82142_c(player.func_82150_aj());
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70142_S, (double)this.entityBat.func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70137_T, (double)this.entityBat.func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70136_U, (double)this.entityBat.func_226281_cx_());
            float f = MathHelper.func_219799_g((float)partialTicks, (float)this.entityBat.field_70126_B, (float)this.entityBat.field_70177_z);
            this.mc.func_175598_ae().func_229084_a_((Entity)this.entityBat, d0, d1, d2, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)this.mc.func_228019_au_().func_228487_b_(), this.mc.func_175598_ae().func_229085_a_((Entity)this.entityBat, partialTicks));
        }
    }

    public boolean shouldRenderBloodVision() {
        return this.bloodVisionTicks > 0 && this.blurShader != null && this.mc.field_71439_g != null;
    }

    private void adjustBloodVisionShaders(float progress) {
        if (this.blit0 == null || this.blur1 == null || this.blur2 == null) {
            return;
        }
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        this.blit0.func_217624_b().func_216538_b("ColorModulate").func_148081_a(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
        this.blur1.func_217624_b().func_216538_b("Radius").func_148090_a((float)Math.round(15.0f * progress));
        this.blur2.func_217624_b().func_216538_b("Radius").func_148090_a((float)Math.round(15.0f * progress));
    }

    private float getBloodVisionProgress(float partialTicks) {
        return ((float)this.bloodVisionTicks + (float)(this.bloodVisionTicks - this.lastBloodVisionTicks) * partialTicks) / 80.0f;
    }

    private void reMakeBloodVisionShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = new ResourceLocation("vampirism", "shaders/blank.json");
        try {
            this.blurShader = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_195551_G(), this.mc.func_147110_a(), resourcelocationBlur);
            Framebuffer swap = this.blurShader.func_177066_a("swap");
            this.blit0 = this.blurShader.func_148023_a("blit", swap, this.mc.func_147110_a());
            this.blur1 = this.blurShader.func_148023_a("blur", this.mc.func_147110_a(), swap);
            this.blur1.func_217624_b().func_216538_b("BlurDir").func_148087_a(1.0f, 0.0f);
            this.blur2 = this.blurShader.func_148023_a("blur", swap, this.mc.func_147110_a());
            this.blur2.func_217624_b().func_216538_b("BlurDir").func_148087_a(0.0f, 1.0f);
            this.blurShader.func_148026_a(this.mc.func_228018_at_().func_198109_k(), this.mc.func_228018_at_().func_198091_l());
        }
        catch (Exception e) {
            this.LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.func_148026_a(width, height);
        }
    }
}

