/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.model.BasicHunterModel;
import de.teamlapen.vampirism.client.render.entities.HunterEquipmentModel;
import de.teamlapen.vampirism.client.render.layers.CloakLayer;
import de.teamlapen.vampirism.client.render.layers.HunterEquipmentLayer;
import de.teamlapen.vampirism.client.render.layers.PlayerFaceOverlayLayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedHunterRenderer
extends BipedRenderer<AdvancedHunterEntity, BasicHunterModel<AdvancedHunterEntity>> {
    private static final ResourceLocation textureCloak = new ResourceLocation("vampirism:textures/entity/hunter_cloak.png");
    private final ResourceLocation texture = new ResourceLocation("vampirism", "textures/entity/hunter_base1.png");

    public AdvancedHunterRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new BasicHunterModel(false), 0.5f);
        this.func_177094_a(new HunterEquipmentLayer(this, h -> HunterEquipmentModel.StakeType.FULL, AdvancedHunterEntity::getHunterType));
        this.func_177094_a(new CloakLayer(this, textureCloak, Predicates.alwaysTrue()));
        if (((Boolean)VampirismConfig.CLIENT.renderAdvancedMobPlayerFaces.get()).booleanValue()) {
            this.func_177094_a(new PlayerFaceOverlayLayer<AdvancedHunterEntity, BasicHunterModel<AdvancedHunterEntity>>(this));
            ((BasicHunterModel)this.func_217764_d()).field_78116_c.field_78806_j = false;
            ((BasicHunterModel)this.func_217764_d()).field_178720_f.field_78806_j = false;
        }
    }

    public ResourceLocation getTextureLocation(AdvancedHunterEntity entity) {
        return this.texture;
    }

    protected void renderNameTag(AdvancedHunterEntity entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double dist = this.field_76990_c.func_229099_b_((Entity)entityIn);
        if (dist <= 256.0) {
            super.func_225629_a_((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn);
        }
    }
}

