/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.model.HunterMinionModel;
import de.teamlapen.vampirism.client.render.entities.DualBipedRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterEquipmentModel;
import de.teamlapen.vampirism.client.render.layers.HunterEquipmentLayer;
import de.teamlapen.vampirism.client.render.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionRenderer
extends DualBipedRenderer<HunterMinionEntity, HunterMinionModel<HunterMinionEntity>> {
    private final Pair<ResourceLocation, Boolean>[] textures = this.gatherTextures("textures/entity/hunter", true);
    private final Pair<ResourceLocation, Boolean>[] minionSpecificTextures = this.gatherTextures("textures/entity/minion/hunter", false);

    public HunterMinionRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new HunterMinionModel(0.5f, false), new HunterMinionModel(0.5f, true), 0.5f);
        this.func_177094_a(new PlayerBodyOverlayLayer(this));
        this.func_177094_a(new HunterEquipmentLayer(this, minion -> minion.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() ? (minion.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b() ? HunterEquipmentModel.StakeType.FULL : HunterEquipmentModel.StakeType.AXE_ONLY) : HunterEquipmentModel.StakeType.NONE, HunterMinionEntity::getHatType));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
    }

    public int getHunterTextureCount() {
        return this.textures.length;
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    @Override
    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(HunterMinionEntity entity) {
        Pair<ResourceLocation, Boolean> p;
        Pair<ResourceLocation, Boolean> pair = p = entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getHunterType() % this.minionSpecificTextures.length] : this.textures[entity.getHunterType() % this.textures.length];
        if (entity.shouldRenderLordSkin()) {
            return entity.getOverlayPlayerProperties().map(Pair::getRight).map(b -> Pair.of((Object)p.getLeft(), (Object)b)).orElse(p);
        }
        return p;
    }

    @Override
    protected void renderSelected(HunterMinionEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void scale(HunterMinionEntity entityIn, MatrixStack matrixStackIn, float partialTickTime) {
        float s = entityIn.func_213355_cm();
        matrixStackIn.func_227862_a_(s, s, s);
    }

    protected void renderNameTag(HunterMinionEntity p_225629_1_, ITextComponent p_225629_2_, MatrixStack p_225629_3_, IRenderTypeBuffer p_225629_4_, int p_225629_5_) {
        p_225629_3_.func_227860_a_();
        p_225629_3_.func_227861_a_(0.0, (double)0.4f, 0.0);
        super.func_225629_a_((Entity)p_225629_1_, p_225629_2_, p_225629_3_, p_225629_4_, p_225629_5_);
        p_225629_3_.func_227865_b_();
    }
}

