/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.render.entities.DualBipedRenderer;
import de.teamlapen.vampirism.client.render.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class VampireMinionRenderer
extends DualBipedRenderer<VampireMinionEntity, PlayerModel<VampireMinionEntity>> {
    private final Pair<ResourceLocation, Boolean>[] textures;
    private final Pair<ResourceLocation, Boolean>[] minionSpecificTextures;

    public VampireMinionRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new PlayerModel(0.0f, false), new PlayerModel(0.0f, true), 0.5f);
        IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
        this.textures = this.gatherTextures("textures/entity/vampire", true);
        this.minionSpecificTextures = this.gatherTextures("textures/entity/minion/vampire", false);
        this.func_177094_a(new PlayerBodyOverlayLayer(this));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        ((PlayerModel)this.func_217764_d()).field_178730_v.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_78115_e.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178732_b.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178723_h.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178734_a.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178724_i.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178733_c.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178722_k.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178731_d.field_78806_j = false;
        ((PlayerModel)this.func_217764_d()).field_178721_j.field_78806_j = false;
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    public int getVampireTextureCount() {
        return this.textures.length;
    }

    @Override
    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(VampireMinionEntity entity) {
        Pair<ResourceLocation, Boolean> p;
        Pair<ResourceLocation, Boolean> pair = p = entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getVampireType() % this.minionSpecificTextures.length] : this.textures[entity.getVampireType() % this.textures.length];
        if (entity.shouldRenderLordSkin()) {
            return entity.getOverlayPlayerProperties().map(Pair::getRight).map(b -> Pair.of((Object)p.getLeft(), (Object)b)).orElse(p);
        }
        return p;
    }

    protected void scale(VampireMinionEntity entityIn, MatrixStack matrixStackIn, float partialTickTime) {
        float s = entityIn.func_213355_cm();
        matrixStackIn.func_227862_a_(s, s, s);
    }
}

