/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.render.entities.HunterEquipmentModel;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HunterEquipmentLayer<T extends MobEntity, Q extends EntityModel<T>>
extends LayerRenderer<T, Q> {
    private final HunterEquipmentModel<T> equipmentModel = new HunterEquipmentModel();
    private final ResourceLocation textureExtra = new ResourceLocation("vampirism", "textures/entity/hunter_extra.png");
    private final Function<T, HunterEquipmentModel.StakeType> predicateStake;
    private final Function<T, Integer> functionHat;

    public HunterEquipmentLayer(IEntityRenderer<T, Q> entityRendererIn, Function<T, HunterEquipmentModel.StakeType> predicateStake, Function<T, Integer> functionHat) {
        super(entityRendererIn);
        this.predicateStake = predicateStake;
        this.functionHat = functionHat;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entityIn.func_82150_aj()) {
            this.equipmentModel.setHat(this.functionHat.apply(entityIn));
            this.equipmentModel.setWeapons(this.predicateStake.apply(entityIn));
            HunterEquipmentLayer.func_229140_a_((EntityModel)this.func_215332_c(), this.equipmentModel, (ResourceLocation)this.textureExtra, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, entityIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

