/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.CoffinTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@OnlyIn(value=Dist.CLIENT)
public class CoffinTESR
extends VampirismTESR<CoffinTileEntity> {
    private static final Marker COFFIN = new MarkerManager.Log4jMarker("COFFIN");
    private final Logger LOGGER = LogManager.getLogger();

    public CoffinTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(@Nonnull CoffinTileEntity tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer iRenderTypeBuffer, int i, int i1) {
        this.renderBlock(tile, partialTicks, matrixStack, iRenderTypeBuffer, i, i1);
    }

    public void renderBlock(CoffinTileEntity tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer iRenderTypeBuffer, int i, int i1) {
        assert (tile.func_145831_w() != null);
        BlockState state = tile.func_195044_w();
        Direction direction = (Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D);
        if (!this.isHeadSafe(tile.func_145831_w(), tile.func_174877_v())) {
            return;
        }
        matrixStack.func_227860_a_();
        boolean vertical = (Boolean)state.func_177229_b((Property)CoffinBlock.VERTICAL);
        switch (direction) {
            case EAST: {
                if (vertical) {
                    matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), 90.0f, true));
                    matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                }
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
                matrixStack.func_227861_a_(-1.0, 0.0, -1.0);
                break;
            }
            case WEST: {
                if (vertical) {
                    matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true));
                    matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
                }
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -90.0f, true));
                matrixStack.func_227861_a_(0.0, 0.0, -2.0);
                break;
            }
            case SOUTH: {
                if (vertical) {
                    matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
                    matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                }
                matrixStack.func_227861_a_(0.0, 0.0, -1.0);
                break;
            }
            case NORTH: {
                if (vertical) {
                    matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
                    matrixStack.func_227861_a_(0.0, 0.0, -1.0);
                }
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
                matrixStack.func_227861_a_(-1.0, 0.0, -2.0);
            }
        }
        IBakedModel baseModel = Minecraft.func_71410_x().func_209506_al().getModel(new ResourceLocation("vampirism", "block/coffin/coffin_bottom_" + tile.color.func_176762_d()));
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(matrixStack.func_227866_c_(), iRenderTypeBuffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false)), state, baseModel, 1.0f, 1.0f, 1.0f, i, i1, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227860_a_();
        if (vertical) {
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), 80.0f * tile.lidPos, true));
            matrixStack.func_227861_a_(0.0, -0.5 * (double)tile.lidPos, 0.0);
        } else {
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -35.0f * tile.lidPos, true));
            matrixStack.func_227861_a_(0.0, 0.0, -0.5 * (double)tile.lidPos);
        }
        IBakedModel lidModel = Minecraft.func_71410_x().func_209506_al().getModel(new ResourceLocation("vampirism", "block/coffin/coffin_top_" + tile.color.func_176762_d()));
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(matrixStack.func_227866_c_(), iRenderTypeBuffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false)), state, lidModel, 1.0f, 1.0f, 1.0f, i, i1, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    private boolean isHeadSafe(World world, BlockPos pos) {
        try {
            return CoffinBlock.isHead((IBlockReader)world, pos);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error(COFFIN, "Failed to check coffin head at {} caused by wrong blockstate. Block at that pos: {}", (Object)pos, (Object)world.func_180495_p(pos));
        }
        catch (Exception e) {
            this.LOGGER.error(COFFIN, "Failed to check coffin head at " + pos + ".", (Throwable)e);
        }
        return false;
    }
}

