/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LordCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_FACTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.lord.no_faction"));
    private static final SimpleCommandExceptionType LEVEL_UP_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.lord.level_failed"));
    private static final SimpleCommandExceptionType LORD_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.lord.failed"));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"lord-level").requires(context -> context.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LordCommand.setLevel((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()})))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> LordCommand.setLevel((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), EntityArgument.func_197090_e((CommandContext)context, (String)"player")))));
    }

    private static int setLevel(CommandContext<CommandSource> context, int level, Collection<ServerPlayerEntity> players) throws CommandSyntaxException {
        for (ServerPlayerEntity player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)player);
            IPlayableFaction<IFactionPlayer<?>> faction = handler.getCurrentFaction();
            if (faction == null) {
                throw NO_FACTION.create();
            }
            int maxLevel = faction.getHighestReachableLevel();
            if (handler.getCurrentLevel() < maxLevel && !handler.setFactionLevel(faction, maxLevel)) {
                throw LEVEL_UP_FAILED.create();
            }
            if (handler.setLordLevel(level = Math.min(level, faction.getHighestLordLevel()))) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.lord.successful", new Object[]{player.func_200200_C_(), faction.getName(), level}), true);
                continue;
            }
            throw LORD_FAILED.create();
        }
        return 0;
    }
}

