/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MinionArgument
implements ArgumentType<MinionId> {
    private final Supplier<Collection<MinionId>> playerMinionIds;

    public MinionArgument() {
        this.playerMinionIds = this::getPlayerMinionIds;
    }

    public MinionArgument(Collection<MinionId> playerMinionIds) {
        this.playerMinionIds = () -> playerMinionIds;
    }

    public static MinionArgument minions() {
        return new MinionArgument();
    }

    public static MinionId getId(CommandContext<CommandSource> source, String argumentId) {
        return (MinionId)source.getArgument(argumentId, MinionId.class);
    }

    private Collection<MinionId> getPlayerMinionIds() {
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        PlayerProfileCache profileCache = ServerLifecycleHooks.getCurrentServer().func_152358_ax();
        return data.getControllers().entrySet().stream().filter(entry -> profileCache.func_152652_a((UUID)entry.getKey()) != null).flatMap(id -> ((PlayerMinionController)id.getValue()).getMinionIdForName(profileCache.func_152652_a((UUID)id.getKey()).getName()).stream()).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining();
        this.filterResources((Iterable)this.playerMinionIds.get(), s, MinionId::toString, arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    <T> void filterResources(Iterable<T> p_210512_0_, String p_210512_1_, Function<T, String> p_210512_2_, Consumer<String> consumer) {
        for (T t : p_210512_0_) {
            String id = p_210512_2_.apply(t);
            if (!ISuggestionProvider.func_237256_a_((String)p_210512_1_, (String)id)) continue;
            consumer.accept(id);
        }
    }

    public MinionId parse(StringReader reader) throws CommandSyntaxException {
        char c;
        StringBuilder builder = new StringBuilder();
        while (reader.canRead() && (c = reader.peek()) != ' ') {
            builder.append(c);
            reader.skip();
        }
        return new MinionId(builder.toString());
    }

    public static class MinionArgumentSerializer
    implements IArgumentSerializer<MinionArgument> {
        public void serializeToNetwork(@Nonnull MinionArgument argument, @Nonnull PacketBuffer buffer) {
            Collection ids = (Collection)argument.playerMinionIds.get();
            buffer.func_150787_b(ids.size());
            ids.forEach(id -> buffer.func_180714_a(id.toString()));
        }

        @Nonnull
        public MinionArgument deserializeFromNetwork(@Nonnull PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            ArrayList<MinionId> ids = new ArrayList<MinionId>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(new MinionId(buffer.func_218666_n()));
            }
            return new MinionArgument(ids);
        }

        public void serializeToJson(@Nonnull MinionArgument argument, @Nonnull JsonObject json) {
            JsonArray array = new JsonArray();
            ((Collection)argument.playerMinionIds.get()).forEach(id -> array.add(id.toString()));
            json.add("playerMinionIds", (JsonElement)array);
        }
    }

    public static class MinionId {
        public final String player;
        public final int id;
        public String name;

        public MinionId(String player, int id, String name) {
            this.player = player;
            this.id = id;
            this.name = name;
        }

        public MinionId(String id) throws NumberFormatException {
            int first = id.indexOf(58);
            this.player = id.substring(0, first);
            int second = id.indexOf(47);
            if (second == -1) {
                this.id = Integer.parseInt(id.substring(first + 1));
                this.name = "";
            } else {
                this.id = Integer.parseInt(id.substring(first + 1, second));
                this.name = id.length() > second + 1 ? id.substring(second + 1) : "";
            }
        }

        public void updateName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.player + ":" + this.id + "/" + this.name;
        }
    }
}

