/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class SkillArgument
implements ArgumentType<ISkill> {
    public static final DynamicCommandExceptionType SKILL_NOT_FOUND = new DynamicCommandExceptionType(particle -> new TranslationTextComponent("command.vampirism.argument.skill.notfound", new Object[]{particle}));
    private static final Collection<String> EXAMPLES = Arrays.asList("skill", "modid:skill");

    public static SkillArgument skills() {
        return new SkillArgument();
    }

    public static ISkill getSkill(CommandContext<CommandSource> context, String name) {
        return (ISkill)context.getArgument(name, ISkill.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a((Iterable)ModRegistries.SKILLS.getKeys(), (SuggestionsBuilder)builder);
    }

    public ISkill parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.func_195826_a((StringReader)reader);
        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(id);
        if (skill == null) {
            throw SKILL_NOT_FOUND.create((Object)id);
        }
        return skill;
    }
}

