/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.mixin.DimensionStructureSettingsAccessor;
import de.teamlapen.vampirism.util.ConfigurableStructureSeparationSettings;
import de.teamlapen.vampirism.world.gen.features.VampireDungeonFeature;
import de.teamlapen.vampirism.world.gen.features.VampirismLakeFeature;
import de.teamlapen.vampirism.world.gen.structures.huntercamp.HunterCampPieces;
import de.teamlapen.vampirism.world.gen.structures.huntercamp.HunterCampStructure;
import de.teamlapen.vampirism.world.gen.treedecorator.TrunkCursedVineTreeDecorator;
import de.teamlapen.vampirism.world.gen.util.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.util.RandomStructureProcessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"vampirism");
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"vampirism");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"vampirism");
    public static final RegistryObject<VampireDungeonFeature> VAMPIRE_DUNGEON = FEATURES.register("vampire_dungeon", () -> new VampireDungeonFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<VampirismLakeFeature> MOD_LAKE = FEATURES.register("mod_lake", () -> new VampirismLakeFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> HUNTER_CAMP = STRUCTURES.register("hunter_camp", () -> {
        HunterCampStructure structure = new HunterCampStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        Structure.field_236385_u_.put(structure, GenerationStage.Decoration.SURFACE_STRUCTURES);
        Structure.field_236365_a_.put((Object)"vampirism:hunter_camp", (Object)structure);
        return structure;
    });
    public static final IStructurePieceType hunter_camp_fireplace = IStructurePieceType.func_214750_a(HunterCampPieces.Fireplace::new, (String)"vampirism:hunter_camp_fireplace");
    public static final IStructurePieceType hunter_camp_tent = IStructurePieceType.func_214750_a(HunterCampPieces.Tent::new, (String)"vampirism:hunter_camp_tent");
    public static final IStructurePieceType hunter_camp_special = IStructurePieceType.func_214750_a(HunterCampPieces.SpecialBlock::new, (String)"vampirism:hunter_camp_craftingtable");
    public static final IStructureProcessorType<RandomStructureProcessor> random_selector = IStructureProcessorType.func_237139_a_((String)"vampirism:random_selector", RandomStructureProcessor.CODEC);
    public static final IStructureProcessorType<BiomeTopBlockProcessor> biome_based = IStructureProcessorType.func_237139_a_((String)"vampirism:biome_based", BiomeTopBlockProcessor.CODEC);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RegistryObject<TreeDecoratorType<TrunkCursedVineTreeDecorator>> TRUNK_CURSED_VINE = TREE_DECORATORS.register("trunk_cursed_vine", () -> new TreeDecoratorType(TrunkCursedVineTreeDecorator.CODEC));

    static void registerFeaturesAndStructures(IEventBus bus) {
        FEATURES.register(bus);
        STRUCTURES.register(bus);
        TREE_DECORATORS.register(bus);
    }

    static void registerIgnoredBiomesForStructures() {
        VampirismAPI.worldGenRegistry().removeStructureFromBiomeCategories(((Structure)HUNTER_CAMP.get()).getRegistryName(), Lists.newArrayList((Object[])new Biome.Category[]{Biome.Category.OCEAN, Biome.Category.THEEND, Biome.Category.NETHER, Biome.Category.BEACH, Biome.Category.ICY, Biome.Category.RIVER, Biome.Category.JUNGLE}));
        VampirismAPI.worldGenRegistry().removeStructureFromBiomes(((Structure)HUNTER_CAMP.get()).getRegistryName(), Lists.newArrayList((Object[])new ResourceLocation[]{ModBiomes.VAMPIRE_FOREST_KEY.func_240901_a_()}));
        VampirismAPI.worldGenRegistry().removeStructureFromBiomes(((Structure)HUNTER_CAMP.get()).getRegistryName(), Lists.newArrayList((Object[])new ResourceLocation[]{ModBiomes.VAMPIRE_FOREST_HILLS_KEY.func_240901_a_()}));
    }

    public static void registerStructureSeparation() {
        DimensionStructuresSettings settings = DimensionSettings.func_242746_i().func_236108_a_();
        HashMap structureSettingsMapOverworld = new HashMap(settings.func_236195_a_());
        ModFeatures.addStructureSeparationSettings(structureSettingsMapOverworld);
        if (((Boolean)VampirismConfig.COMMON.villageModify.get()).booleanValue()) {
            LOGGER.info("Replacing vanilla village structure separation settings for the overworld dimension preset");
            structureSettingsMapOverworld.put(Structure.field_236381_q_, new ConfigurableStructureSeparationSettings(VampirismConfig.COMMON.villageDistance, VampirismConfig.COMMON.villageSeparation, ((StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get((Object)Structure.field_236381_q_)).func_236673_c_()));
        } else {
            LOGGER.trace("Not modifying village");
        }
        ((DimensionStructureSettingsAccessor)settings).setStructureSeparation_vampirism(structureSettingsMapOverworld);
    }

    public static void checkWorldStructureSeparation(RegistryKey<World> dimension, boolean flatWorld, DimensionStructuresSettings settings) {
        if (dimension.compareTo(World.field_234918_g_) != 0 || flatWorld) {
            return;
        }
        if (!((Boolean)VampirismConfig.COMMON.enforceTentGeneration.get()).booleanValue()) {
            return;
        }
        HashMap structureSettings = new HashMap(settings.func_236195_a_());
        if (!structureSettings.containsKey(HUNTER_CAMP.get())) {
            LOGGER.info("Cannot find hunter camp configuration for loaded world -> Adding");
            int dist = (Integer)VampirismConfig.COMMON.hunterTentDistance.get();
            int sep = (Integer)VampirismConfig.COMMON.hunterTentSeparation.get();
            if (dist <= sep) {
                LOGGER.warn("Hunter tent distance must be larger than separation. Adjusting");
                dist = sep + 1;
            }
            structureSettings.put((Structure<?>)HUNTER_CAMP.get(), new StructureSeparationSettings(dist, sep, 14357719));
        }
        ((DimensionStructureSettingsAccessor)settings).setStructureSeparation_vampirism(structureSettings);
    }

    private static void addStructureSeparationSettings(Map<Structure<?>, StructureSeparationSettings> settings) {
        settings.put((Structure<?>)HUNTER_CAMP.get(), new ConfigurableStructureSeparationSettings(VampirismConfig.COMMON.hunterTentDistance, VampirismConfig.COMMON.hunterTentSeparation, 14357719));
    }
}

