/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"vampirism");
    public static final RegistryObject<ParticleType<FlyingBloodParticleData>> FLYING_BLOOD = PARTICLES.register("flying_blood", () -> new ParticleType<FlyingBloodParticleData>(false, FlyingBloodParticleData.DESERIALIZER){

        public Codec<FlyingBloodParticleData> func_230522_e_() {
            return FlyingBloodParticleData.CODEC;
        }
    });
    public static final RegistryObject<ParticleType<FlyingBloodEntityParticleData>> FLYING_BLOOD_ENTITY = PARTICLES.register("flying_blood_entity", () -> new ParticleType<FlyingBloodEntityParticleData>(false, FlyingBloodEntityParticleData.DESERIALIZER){

        public Codec<FlyingBloodEntityParticleData> func_230522_e_() {
            return FlyingBloodEntityParticleData.CODEC;
        }
    });
    public static final RegistryObject<ParticleType<GenericParticleData>> GENERIC = PARTICLES.register("generic", () -> new ParticleType<GenericParticleData>(false, GenericParticleData.DESERIALIZER){

        public Codec<GenericParticleData> func_230522_e_() {
            return GenericParticleData.CODEC;
        }
    });

    static void registerParticles(IEventBus bus) {
        PARTICLES.register(bus);
    }

    public static void spawnParticlesClient(World worldIn, IParticleData particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int count, double maxDist, Random rand) {
        assert (!(worldIn instanceof ServerWorld)) : "Calling spawnParticlesClient on ServerWorld is pointless";
        for (int i = 0; i < count; ++i) {
            worldIn.func_195594_a(particle, x + maxDist * (2.0 * rand.nextDouble() - 1.0), y + (2.0 * rand.nextDouble() - 1.0) * maxDist, z + (2.0 * rand.nextDouble() - 1.0) * maxDist, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticlesClient(World worldIn, IParticleData particle, double x, double y, double z, int count, double maxDist, Random rand) {
        ModParticles.spawnParticlesClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0, count, maxDist, rand);
    }

    public static void spawnParticleClient(World worldIn, IParticleData particle, double x, double y, double z) {
        ModParticles.spawnParticleClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnParticleClient(World worldIn, IParticleData particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        assert (!(worldIn instanceof ServerWorld)) : "Calling spawnParticleClient on ServerWorld is pointless";
        worldIn.func_195594_a(particle, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static int spawnParticlesServer(World worldIn, IParticleData particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        assert (worldIn instanceof ServerWorld) : "Calling spawnParticlesServer on client side is pointless";
        if (worldIn instanceof ServerWorld) {
            return ((ServerWorld)worldIn).func_195598_a(particle, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        }
        return 0;
    }
}

